proc isSystemVerilog {filename} {
    # Search "DPI-C"
    set iChannel [open $filename]
    set found 0
    while {1} {
        set rc [gets $iChannel line]
        if {$rc == -1} {
            break
        }
        # Ignore any comments
        regsub "//.*" $line "" line

        if {[regexp "\"DPI-C\"" $line]} {
            set found 1
        }
    }
    close $iChannel
    return $found
}

proc gatherFiles {hdl command command_sv} {
    global env

    if {$hdl eq "verilog"} {
        foreach {i} [glob -type f -- \
            $env(NOODLYBOX_HOME)/model/*.v \
            ../model/*.v \
            $env(NOODLYBOX_HOME)/sample/rtl/*.v \
            ] {
            if {[regexp ".*/MPU.v" $i]} {
                #do nothing
            } elseif {[isSystemVerilog $i]} {
                eval $command_sv
            } else {
                eval $command
            }
        }
        foreach {i} [glob -type f -- \
            $env(NOODLYBOX_HOME)/model/*.sv \
            ] {
            eval $command
        }
    }
}

proc create_msimproj {hdl projname} {
    project new . $projname
    set command    {project addfile $i}
    set command_sv {project addfile $i systemverilog "Top Level"}
    gatherFiles $hdl $command $command_sv

    project calculateorder
    project close
    exit -force
}

# main ----
if [catch {
    set soft     [lindex $argv 0]
    set hdl      [lindex $argv 1]
    set projname [lindex $argv 2]

    if       {$soft eq "msim"} {
        create_msimproj $hdl $projname
    }
} errorKind ] {
    # Exception trap
    puts stderr $errorInfo
    error $errorKind
}
