# Defining echo canceller.
proc silent args {
}

silent [package require cmdline]
silent [set dbg 0]
silent [set starttime 0]

# Put the debug information.
proc putdbg {str} {
    if {$::dbg} { puts stderr $str }
}

# Interpret all specified options.
proc interpretOptions {} {
    set specified ""

    global 1
    while {$::argc > 0} {
        append specified " " $1
        shift
    }

    putdbg "-- $specified --"

    while {[::cmdline::getopt specified {q t} optvar valvar]} {
        if {$optvar eq "q"} {
            onbreak { quit -force }
        } elseif {$optvar eq "t"} {
            set ::starttime [clock clicks -milliseconds]
            onbreak { puts stdout \
                "time : [expr [clock clicks -milliseconds] - $::starttime] ms"}
        }
    }
}

proc adjustgrid_by {filename} {
    set iChannel [open $filename]
    set match  0
    set period 0
    while {1} {
        set rc [gets $iChannel line]
        if {$rc == -1} {
            break
        }
        # Ignore any comments
        regsub "//.*" $line "" line

        # Searching clock period
        if {[regexp "localparam.*STEP.*?(\\d+)" $line ignore match]} {
            putdbg "-- gridperiod : $match --"
        }
    }
    close $iChannel

    if {$match} {
        set full $match
        set half [expr $full / 2]
        append full "ns"
        append half "ns"
        configure wave -gridoffset $half -gridperiod $full -timeline 1
    }
}

# main ----

interpretOptions

#                           dpi dll  top module
vsim -L unisims_ver -sv_lib c_side   tDPI

adjustgrid_by ../model/tDPI.v
add wave -r -hex /*
run 100 us
