// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2008, molelord
// All rights reserved.

// Simple DCM model
//
//  When this model is synthesised, it instantiates real "DCM".
//
// The following functions are not implemented yet.
//  input  RST
//  input  DSSEN
//  input  PSCLK
//  input  PSEN
//  input  PSINCDEC
//  output CLK90
//  output CLK270
//  output PSDONE
//  output STATUS

`timescale 1 ns / 1 ns

module MIMIC_DCM # (
    parameter XILINX_MODEL          = 0,
    parameter CLKDV_DIVIDE          = 2.0,
    parameter CLKFX_DIVIDE          = 1,
    parameter CLKFX_MULTIPLY        = 4,
    parameter CLKIN_DIVIDE_BY_2     = "FALSE",
    parameter CLKIN_PERIOD          = 10.0,
    parameter CLKOUT_PHASE_SHIFT    = "NONE",
    parameter CLK_FEEDBACK          = "1X",
    parameter DESKEW_ADJUST         = "SYSTEM_SYNCHRONOUS",
    parameter DFS_FREQUENCY_MODE    = "LOW",
    parameter DLL_FREQUENCY_MODE    = "LOW",
    parameter DSS_MODE              = "NONE",
    parameter DUTY_CYCLE_CORRECTION = "TRUE",
    parameter FACTORY_JF            = 16'hC080,
    parameter PHASE_SHIFT           = 0,
    parameter STARTUP_WAIT          = "FALSE")
(
    output wire CLK0,
    output wire CLK180,
    output wire CLK270,
    output wire CLK2X,
    output wire CLK2X180,
    output wire CLK90,
    output wire CLKDV,
    output wire CLKFX,
    output wire CLKFX180,
    output wire LOCKED,
    output wire PSDONE,
    output wire [7:0] STATUS,
    input  wire CLKFB,
    input  wire CLKIN,
    input  wire DSSEN,
    input  wire PSCLK,
    input  wire PSEN,
    input  wire PSINCDEC,
    input  wire RST);

    localparam ORIGINAL =
// synthesis translate_off
        (XILINX_MODEL == 0) ? 0 :
// synthesis translate_on
        1;

// synthesis translate_off
    wire W_LOCKED_0;
    wire W_LOCKED_2X;
    wire W_LOCKED_FX;
    wire W_LOCKED_DV;
// synthesis translate_on

    generate if (ORIGINAL) begin
        DCM # (
            .CLKDV_DIVIDE          (CLKDV_DIVIDE),
            .CLKFX_DIVIDE          (CLKFX_DIVIDE),
            .CLKFX_MULTIPLY        (CLKFX_MULTIPLY),
            .CLKIN_DIVIDE_BY_2     (CLKIN_DIVIDE_BY_2),
            .CLKIN_PERIOD          (CLKIN_PERIOD),
            .CLKOUT_PHASE_SHIFT    (CLKOUT_PHASE_SHIFT),
            .CLK_FEEDBACK          (CLK_FEEDBACK),
            .DESKEW_ADJUST         (DESKEW_ADJUST),
            .DFS_FREQUENCY_MODE    (DFS_FREQUENCY_MODE),
            .DLL_FREQUENCY_MODE    (DLL_FREQUENCY_MODE),
            .DSS_MODE              (DSS_MODE),
            .DUTY_CYCLE_CORRECTION (DUTY_CYCLE_CORRECTION),
            .FACTORY_JF            (FACTORY_JF),
            .PHASE_SHIFT           (PHASE_SHIFT),
            .STARTUP_WAIT          (STARTUP_WAIT))
        uDCM (
            .CLK0     (CLK0),
            .CLK180   (CLK180),
            .CLK270   (CLK270),
            .CLK2X    (CLK2X),
            .CLK2X180 (CLK2X180),
            .CLK90    (CLK90),
            .CLKDV    (CLKDV),
            .CLKFX    (CLKFX),
            .CLKFX180 (CLKFX180),
            .LOCKED   (LOCKED),
            .PSDONE   (PSDONE),
            .STATUS   (STATUS),
            .CLKFB    (CLKFB),
            .CLKIN    (CLKIN),
            .DSSEN    (DSSEN),
            .PSCLK    (PSCLK),
            .PSEN     (PSEN),
            .PSINCDEC (PSINCDEC),
            .RST      (RST));
    end endgenerate

// synthesis translate_off
    generate if (!ORIGINAL) begin
        MIMIC_PLL # (
            .MULTIPLY (1),
            .DIVIDE   (1))
        uMIMIC_PLL_0 (
            .INCLK    (CLKIN),
            .OUTCLK   (CLK0),
            .OUTCLK_X (CLK180),
            .LOCKED   (W_LOCKED_0));

        MIMIC_PLL # (
            .MULTIPLY (2),
            .DIVIDE   (1))
        uMIMIC_PLL_2X (
            .INCLK    (CLKIN),
            .OUTCLK   (CLK2X),
            .OUTCLK_X (CLK2X180),
            .LOCKED   (W_LOCKED_2X));

        MIMIC_PLL # (
            .MULTIPLY (CLKFX_MULTIPLY),
            .DIVIDE   (CLKFX_DIVIDE))
        uMIMIC_PLL_FX (
            .INCLK    (CLKIN),
            .OUTCLK   (CLKFX),
            .OUTCLK_X (CLKFX180),
            .LOCKED   (W_LOCKED_FX));

        MIMIC_PLL # (
            .MULTIPLY (1),
            .DIVIDE   (CLKDV_DIVIDE))
        uMIMIC_PLL_DV (
            .INCLK    (CLKIN),
            .OUTCLK   (CLKDV),
            .OUTCLK_X (/*open*/),
            .LOCKED   (W_LOCKED_DV));
    end endgenerate
    assign LOCKED = W_LOCKED_0 & W_LOCKED_2X & W_LOCKED_FX & W_LOCKED_DV;
// synthesis translate_on
endmodule
