-- This software is a part of NOODLYBOX.
-- This software is distributed under the terms of the new BSD License.
-- Copyright (c) 2008, molelord
-- All rights reserved.

-- Simple DCM model
--
--  When this model is synthesised, it instantiates real "DCM".
--
-- The following functions are not implemented yet.
--  input  RST
--  input  DSSEN
--  input  PSCLK
--  input  PSEN
--  input  PSINCDEC
--  output CLK90
--  output CLK270
--  output PSDONE
--  output STATUS

library ieee;
use ieee.std_logic_1164.all;

-- synthesis translate_off
use work.MIMIC_PLL_PKG.all;
-- synthesis translate_on

library UNISIM;
use UNISIM.Vcomponents.all; -- DCM

entity MIMIC_DCM is
    generic (
        XILINX_MODEL          : boolean    := false;
        CLKDV_DIVIDE          : real       := 2.0;
        CLKFX_DIVIDE          : integer    := 1;
        CLKFX_MULTIPLY        : integer    := 4;
        CLKIN_DIVIDE_BY_2     : boolean    := false;
        CLKIN_PERIOD          : real       := 10.0;
        CLKOUT_PHASE_SHIFT    : string     := "NONE";
        CLK_FEEDBACK          : string     := "1X";
        DESKEW_ADJUST         : string     := "SYSTEM_SYNCHRONOUS";
        DFS_FREQUENCY_MODE    : string     := "LOW";
        DLL_FREQUENCY_MODE    : string     := "LOW";
        DSS_MODE              : string     := "NONE";
        DUTY_CYCLE_CORRECTION : boolean    := true;
        FACTORY_JF            : bit_vector := X"C080";
        PHASE_SHIFT           : integer    := 0;
        STARTUP_WAIT          : boolean    := false);
    port (
        CLK0     : out std_ulogic;
        CLK180   : out std_ulogic;
        CLK270   : out std_ulogic;
        CLK2X    : out std_ulogic;
        CLK2X180 : out std_ulogic;
        CLK90    : out std_ulogic;
        CLKDV    : out std_ulogic;
        CLKFX    : out std_ulogic;
        CLKFX180 : out std_ulogic;
        LOCKED   : out std_ulogic;
        PSDONE   : out std_ulogic;
        STATUS   : out std_logic_vector(7 downto 0);
        CLKFB    : in  std_ulogic;
        CLKIN    : in  std_ulogic;
        DSSEN    : in  std_ulogic;
        PSCLK    : in  std_ulogic;
        PSEN     : in  std_ulogic;
        PSINCDEC : in  std_ulogic;
        RST      : in  std_ulogic);
end MIMIC_DCM;

architecture RTL of MIMIC_DCM is

    constant ORIGINAL : boolean :=
-- synthesis translate_off
        XILINX_MODEL or not
-- synthesis translate_on
        true;

-- synthesis translate_off
    signal W_LOCKED_0  : std_ulogic;
    signal W_LOCKED_2X : std_ulogic;
    signal W_LOCKED_FX : std_ulogic;
    signal W_LOCKED_DV : std_ulogic;
-- synthesis translate_on

begin
    O : if (ORIGINAL) generate
        UDCM : DCM generic map (
            CLKDV_DIVIDE          => CLKDV_DIVIDE,
            CLKFX_DIVIDE          => CLKFX_DIVIDE,
            CLKFX_MULTIPLY        => CLKFX_MULTIPLY,
            CLKIN_DIVIDE_BY_2     => CLKIN_DIVIDE_BY_2,
            CLKIN_PERIOD          => CLKIN_PERIOD,
            CLKOUT_PHASE_SHIFT    => CLKOUT_PHASE_SHIFT,
            CLK_FEEDBACK          => CLK_FEEDBACK,
            DESKEW_ADJUST         => DESKEW_ADJUST,
            DFS_FREQUENCY_MODE    => DFS_FREQUENCY_MODE,
            DLL_FREQUENCY_MODE    => DLL_FREQUENCY_MODE,
            DSS_MODE              => DSS_MODE,
            DUTY_CYCLE_CORRECTION => DUTY_CYCLE_CORRECTION,
            FACTORY_JF            => FACTORY_JF,
            PHASE_SHIFT           => PHASE_SHIFT,
            STARTUP_WAIT          => STARTUP_WAIT)
        port map (
            CLK0     => CLK0,
            CLK180   => CLK180,
            CLK270   => CLK270,
            CLK2X    => CLK2X,
            CLK2X180 => CLK2X180,
            CLK90    => CLK90,
            CLKDV    => CLKDV,
            CLKFX    => CLKFX,
            CLKFX180 => CLKFX180,
            LOCKED   => LOCKED,
            PSDONE   => PSDONE,
            STATUS   => STATUS,
            CLKFB    => CLKFB,
            CLKIN    => CLKIN,
            DSSEN    => DSSEN,
            PSCLK    => PSCLK,
            PSEN     => PSEN,
            PSINCDEC => PSINCDEC,
            RST      => RST);
    end generate;

-- synthesis translate_off
    X : if (not ORIGINAL) generate
        UMIMIC_PLL_0  : MIMIC_PLL generic map (
            MULTIPLY => 1,
            DIVIDE   => 1)
        port map (
            INCLK    => CLKIN,
            OUTCLK   => CLK0,
            OUTCLK_X => CLK180,
            LOCKED   => W_LOCKED_0);

        UMIMIC_PLL_2X : MIMIC_PLL generic map (
            MULTIPLY => 2,
            DIVIDE   => 1)
        port map (
            INCLK    => CLKIN,
            OUTCLK   => CLK2X,
            OUTCLK_X => CLK2X180,
            LOCKED   => W_LOCKED_2X);

        UMIMIC_PLL_FX : MIMIC_PLL generic map (
            MULTIPLY => CLKFX_MULTIPLY,
            DIVIDE   => CLKFX_DIVIDE)
        port map (
            INCLK    => CLKIN,
            OUTCLK   => CLKFX,
            OUTCLK_X => CLKFX180,
            LOCKED   => W_LOCKED_FX);

        UMIMIC_PLL_DV : MIMIC_PLL generic map (
            MULTIPLY => 1,
            DIVIDE   => integer(CLKDV_DIVIDE))
        port map (
            INCLK    => CLKIN,
            OUTCLK   => CLKDV,
            --OUTCLK_X =>
            LOCKED   => W_LOCKED_DV);
    end generate;
    LOCKED <= W_LOCKED_0 and W_LOCKED_2X and W_LOCKED_FX and W_LOCKED_DV;
-- synthesis translate_on
end RTL;
