-- This software is a part of NOODLYBOX.
-- This software is distributed under the terms of the new BSD License.
-- Copyright (c) 2008, molelord
-- All rights reserved.

-- Simple PLL model
--
--  The lock time of this model is too faster than real device.
--  It is a good point, but it is a bad point too.
--  Should be careful to it for using this model.

library ieee;
use ieee.std_logic_1164.all;

entity MIMIC_PLL is
    generic (
        MULTIPLY : integer := 2;  -- can accept integer more than 1.
        DIVIDE   : integer := 1); -- can accept integer more than 1.
    port (
        INCLK    : in  std_logic;
        OUTCLK   : out std_logic;
        OUTCLK_X : out std_logic;
        LOCKED   : out std_logic);
end MIMIC_PLL;

architecture SIM of MIMIC_PLL is
    signal NEWTIME     : time := 0 ns;
    signal OLDTIME     : time := 0 ns;
    signal INCLK_STEP  : time := 0 ns;
    signal OUTCLK_STEP : time := 0 ns;

begin

    process (INCLK) begin
        if (INCLK'event and INCLK = '1') then
            NEWTIME     <= NOW;
            INCLK_STEP  <= NEWTIME - OLDTIME;
            OUTCLK_STEP <= INCLK_STEP * DIVIDE / MULTIPLY;
            OLDTIME     <= NEWTIME;
        end if;
    end process;

    process
        variable NEXTTIME : time;
        variable j        : integer;
    begin
        LOCKED   <= '0';
        OUTCLK   <= '0';
        OUTCLK_X <= '1';

        -- Five clocks are necessary till OUTCLK_STEP is calculated.
        for i in 1 to 5 loop
            wait until (INCLK'event and INCLK = '1');
        end loop;

        while (true) loop
            OUTCLK <= '1'; OUTCLK_X <= '0';
            wait for OUTCLK_STEP/2;
            OUTCLK <= '0'; OUTCLK_X <= '1';

            for i in 2 to MULTIPLY loop
                wait for OUTCLK_STEP/2;
                OUTCLK <= '1'; OUTCLK_X <= '0';
                wait for OUTCLK_STEP/2;
                OUTCLK <= '0'; OUTCLK_X <= '1';
            end loop;

            LOCKED <= '1';

            -- Next transition occurs at next rising edge of input clock.
            j := 1;
            NEXTTIME := NEWTIME + INCLK_STEP * j - NOW;
            while (NEXTTIME < OUTCLK_STEP/2) loop
                j := j + 1;
                NEXTTIME := NEWTIME + INCLK_STEP * j - NOW;
            end loop;

            wait for NEXTTIME;
        end loop;
    end process;

end SIM;
