// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

`timescale 1 ns / 1 ns

module MPU # (
    parameter MPU_ID   = 0,
    parameter MPU_NAME = "")
(
    output reg  [31:0] A,
    input  wire [31:0] DIN,
    output reg  [31:0] DOUT,
    input  wire [31:0] CTRLI,
    output reg  [31:0] CTRLO,
    input  wire        CLK);

    // This variable stores the pointer to MPU.
    chandle i_MPU_HANDLE;

    int     i_NEED_NEXT_RISING = 0;

    import "DPI-C" function chandle c_startup1st(
        input  int    mpu_id,
        input  string mpu_name);

    import "DPI-C" context task c_startup2nd(
        input  chandle mpu_handle);

    import "DPI-C" context task c_reflect(
        input  chandle mpu_handle,
        output [31:0]  a,
        output [31:0]  dout,
        input  [31:0]  ctrli,
        output [31:0]  ctrlo,
        input  int     clk,
        output int     need_next_rising);

    import "DPI-C" context task c_reflect_din(
        input  chandle mpu_handle,
        input  [31:0]  din);

    export "DPI-C" task v_stop;
    export "DPI-C" task v_write;
    export "DPI-C" task v_waitClock;

    task v_stop;
        $stop;
    endtask

    task v_write(input int x);
        $display("%h", x);
    endtask

    task v_waitClock();
        if (i_NEED_NEXT_RISING == 0) begin
            @(posedge CLK);
        end
        c_reflect(i_MPU_HANDLE, A, DOUT, CTRLI, CTRLO, 1, i_NEED_NEXT_RISING);

        @(negedge CLK);
        c_reflect(i_MPU_HANDLE, A, DOUT, CTRLI, CTRLO, 0, i_NEED_NEXT_RISING);

        if (i_NEED_NEXT_RISING == 1) begin
            @(posedge CLK);
            c_reflect_din(i_MPU_HANDLE, DIN);
        end
    endtask

    initial begin
        i_MPU_HANDLE = c_startup1st(MPU_ID, MPU_NAME);
        c_startup2nd(i_MPU_HANDLE);
        $stop;
    end

endmodule
// vim:set ft=verilog:
