// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

`timescale 1 ns / 1 ns

module MPU # (
    parameter MPU_ID   = 0,
    parameter MPU_NAME = "")
(
    output wire [31:0] A,
    input  wire [31:0] DIN,
    output wire [31:0] DOUT,
    input  wire [31:0] CTRLI,
    output wire [31:0] CTRLO,
    input  wire        CLK);

    // C側で名前付きパイプを双方向にしてあっても、それに$fwrite()しようと
    // すると失敗した。そこで、C側で単方向の名前付きパイプを2本作成し、
    // WriteとReadは別々のパイプを経由するようにした。
    integer    fdw; // file descriptor for writing
    integer    fdr; // file descriptor for reading

    integer    rc; // return code
    reg [32+32+32-1:0] i_A_DOUT_CTRLO;

    reg  [7:0] i_MPU_ID = MPU_ID + 'h30; // integer to char

    task endofsim(); begin
        $fclose(fdw);
        $fclose(fdr);
        $stop();
    end endtask

    initial begin
        fdw = $fopen({"\\\\.\\pipe\\v2c", i_MPU_ID, MPU_NAME}, "wb");
        fdr = $fopen({"\\\\.\\pipe\\c2v", i_MPU_ID, MPU_NAME}, "rb");

        forever begin
            @(posedge CLK);
            $fwriteb(fdw, DIN, CTRLI);
            // flushしないと、バッファに溜まるだけでC側に伝わらない
            $fflush(fdw);
            rc = $fread(i_A_DOUT_CTRLO, fdr);
            if (rc == 0) endofsim(); // すべて読み出し終えたら終わる

            @(negedge CLK);
            // 高速化のため、立ち下がりでのDIN, CTRLIは伝えないことにした
            //$fwriteb(fdw, DIN, CTRLI);
            // flushしないと、バッファに溜まるだけでC側に伝わらない
            //$fflush(fdw);
            rc = $fread(i_A_DOUT_CTRLO, fdr);
            if (rc == 0) endofsim(); // すべて読み出し終えたら終わる
        end
    end
    assign {A, DOUT, CTRLO} = i_A_DOUT_CTRLO;
        
endmodule
