#include "samplefpga.h" // Samplefpga

#if !defined(REALWORLD)
#   include <cstdio>  // printf()
#   include <cstdlib> // EXIT_FAILURE

static const char * const logname = "accessfpga.log";

using namespace std;

// コンストラクタの引数には、
// ・プロセッサのメモリ空間上の、FPGAが見えているアドレス
// ・プロセッサとFPGAを繋いでいるデータバスの幅
// を与える
Samplefpga fpga(0x04000000U, 16);
#else
#   include <stdio.h> // printf()
// TODO 実機の場合、FPGAが見えているアドレスはリンカスクリプトで
// 指定するべきなのだが、暫定的に#defineで与えることにする
#   define fpga (*((volatile Samplefpga *)0x04000000U))
#endif

// 裏方は複雑なことをしているが、すべてはこの関数を普通のC言語プログラムに
// 見えるように、つまりは実機向けにコンパイル可能にするために存在する
static void userprogram(void)
{
    int i;
    uint32_t tmp;
    FILE *fp;
    const uint32_t Step = 16; // 周期[ns] tDPI.vと同じ値を指定する

    fp = fopen(logname, "w");
    if (fp == NULL) {
        exit(EXIT_FAILURE);
    }
    // 処理開始
    // DCMのロックを待つ
    fpga.nop(10);

    // FPGAのレジスタをアクセス
    for (i = 0; i < 100; i++) {
        fpga.FREERUN = i;
        fpga.GPOUT   = i * 10;
    }

    // 512ns待つ
    fpga.nop(512 / Step);

    for (i = 0; i < 100; i++) {
        tmp = fpga.FREERUN;
        fprintf(fp, "getFREERUN : 0x%04x\n", tmp);
    }

    fpga.GPOUT = 0x5678;

    tmp = fpga.GPOUT;
    fprintf(fp, "getGPOUT : 0x%04x\n", tmp);

    fclose(fp);

#if 1
    // Tcl実装と違い、DPI-C実装では標準出力を自由に使用できる
    // printf()やcoutを使うと、ModelSimではTranscriptウィンドウに
    // 表示される
    uint16_t rc;
    rc = fpga.GPOUT = fpga.FREERUN - fpga.GPOUT;
    printf("%s(%d): FREERUN - GPOUT: 0x%04x\n", __FILE__, __LINE__, rc);
#endif
}

#if !defined(REALWORLD)
// ユーザプログラムのうち、最初に呼ばれる関数
// この関数を除いて、ユーザプログラム中の関数名は任意である
// この関数は、シミュレータ上のプロセッサの数と同じ回数だけ呼び出される
void userstartup(nbox::MpuIf *mpu)
{
    switch (mpu->getId()) {
        case 0: {
            fpga.setMpu(mpu);
            // mpu_idが0のプロセッサのためのユーザ処理へ飛ぶ
            userprogram();
        } break;
        default: break;
    }
}
#endif
