`timescale 1 ns / 1 ns

module tPIPE;

    localparam STEP = 16;
    reg         i_CLK;
    reg         i_RESET_X;
    wire [15:0] i_GPOUT;

    wire        i_CS_X;
    wire        i_OE_X;
    wire        i_WE_X;
    wire        i_BS_X;
    wire        i_RDWR;
    wire [31:0] i_A;
    wire [31:0] i_D;

    initial begin
        i_CLK = 1'b0;
        i_RESET_X = 1'b0;
        #(STEP);
        #(STEP/5);
        i_RESET_X = 1'b1;
    end

    always begin
        #(STEP/2);
        i_CLK = ~i_CLK;
    end

    SH7751 # (
        .MPU_ID(0))
    uSH7751(
        .CS_X(i_CS_X),
        .OE_X(i_OE_X),
        .WE_X(i_WE_X),
        .BS_X(i_BS_X),
        .RDWR(i_RDWR),
        .A   (i_A),
        .D   (i_D),
        .CLK (i_CLK),
        .RESET_X(i_RESET_X));

`define FPGA
`ifdef FPGA
    // Device Under Verification
    SAMPLEFPGA uDUV (
        .CS_X    (i_CS_X),
        .BS_X    (i_BS_X),
        .RDWR    (i_RDWR),
        .A       (i_A[7:0]),
        .D       (i_D[15:0]),
        .GPOUT   (i_GPOUT),
        .CLK     (i_CLK),
        .RESET_X (i_RESET_X));
`else
    reg  [31:0] i_DEVICE_D;

    // for debugging read operations.
    always @(*) begin
        if (i_OE_X == 1'b0) begin
            i_DEVICE_D <= i_A;
        end
        else begin
            i_DEVICE_D <= 32'bz;
        end
    end
    assign i_D = i_DEVICE_D;
`endif

endmodule
