-- tMIMIC_DCM.v
-- 簡易PLLモデル のテストベンチ
--
-- MIMIC_DCMに、入力クロックに対してエッジが揃った出力クロックを出す能力が
-- あることを確かめるために、
--  1. 入力クロックで更新されるカウンタの値 を 出力クロックドメイン に渡す
--  2. 出力クロックで更新されるカウンタの値 を 入力クロックドメイン に渡す
-- を行う。
-- もし双方のエッジにデルタ遅延などでずれがある場合は、送り側の値が即座に
-- 相手側に伝わってしまう。期待値は、1と2の両方で、送り側の値の変化が
-- ワンテンポ遅れて相手に伝わること。

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all; -- operator '+'
use work.MIMIC_DCM_PKG.all;

entity tMIMIC_DCM is
end tMIMIC_DCM;

architecture SIM of tMIMIC_DCM is

    constant STEP   : time := 10 ns;

    signal   CLK0   : std_logic;
    signal   CLK2X  : std_logic;
    signal   CLKFX  : std_logic;
    signal   CLKDV  : std_logic;

    signal   INCLK  : std_logic := '0';
    signal   LOCKED : std_logic;

    signal   R_SEND_FROM_I  : std_logic_vector(3 downto 0) := (others=>'0');
    signal   R_RECEIVE_BY_O : std_logic_vector(R_SEND_FROM_I'range);

    signal   R_SEND_FROM_O  : std_logic_vector(3 downto 0) := (others=>'0');
    signal   R_RECEIVE_BY_I : std_logic_vector(R_SEND_FROM_O'range);

begin

    process begin
        wait for STEP/2;
        INCLK <= not INCLK;
    end process;

    DUT : MIMIC_DCM generic map (
        CLKDV_DIVIDE      => 3.0,
        CLKFX_DIVIDE      => 3,
        CLKFX_MULTIPLY    => 2)
    port map (
        CLK0     => CLK0,
        CLK2X    => CLK2X,
        CLKFX    => CLKFX,
        CLKDV    => CLKDV,
        LOCKED   => LOCKED,

        CLKFB    => CLK0,
        CLKIN    => INCLK,
        DSSEN    => '0',
        PSCLK    => '0',
        PSEN     => '0',
        PSINCDEC => '0',
        RST      => '0');

    -- クロックドメインを超えたデータのやり取り 入力クロック→?倍速クロック
    process (INCLK) begin
        if (INCLK'event and INCLK = '1') then
            R_SEND_FROM_I <= R_SEND_FROM_I + 1;
        end if;
    end process;
    process (CLKFX) begin
        if (CLKFX'event and CLKFX = '1') then
            R_RECEIVE_BY_O <= R_SEND_FROM_I;
        end if;
    end process;


    -- クロックドメインを超えたデータのやり取り ?倍速クロック→入力クロック
    process (CLKFX) begin
        if (CLKFX'event and CLKFX = '1') then
            R_SEND_FROM_O <= R_SEND_FROM_O + 1;
        end if;
    end process;
    process (INCLK) begin
        if (INCLK'event and INCLK = '1') then
            R_RECEIVE_BY_I <= R_SEND_FROM_O;
        end if;
    end process;

end SIM;
