// SAMPLEFPGAのテストベンチ

`timescale 1 ns / 1 ns

module tSAMPLEFPGA;

    wire        CS_X;
    wire        OE_X;
    wire        WE_X;
    wire        BS_X;
    wire        RDWR;
    wire [31:0] A;
    wire [31:0] D;
    reg         CLK     = 0;
    reg         RESET_X = 0;

    wire [15:0] GPOUT;

    localparam CLOCK_PERIOD = 16;

    always begin
        CLK = ~CLK; #(CLOCK_PERIOD/2);
    end

    initial begin
        #(300); // モデルのDCMがロックするのを待つ
        RESET_X = 1;
    end

    NOODLYBOX # (
        .CLOCK_PERIOD(CLOCK_PERIOD))
    uBOX (
        .CS_X    (CS_X),
        .OE_X    (OE_X),
        .WE_X    (WE_X),
        .BS_X    (BS_X),
        .RDWR    (RDWR),
        .A       (A),
        .D       (D),
        .CLK     (CLK),
        .RESET_X (RESET_X));

    // Device Under Verification
    SAMPLEFPGA uDUV (
        .CS_X    (CS_X),
        .BS_X    (BS_X),
        .RDWR    (RDWR),
        .A       (A[7:0]),
        .D       (D[15:0]),
        .GPOUT   (GPOUT),
        .CLK     (CLK),
        .RESET_X (RESET_X));

endmodule
