`timescale 1 ns / 1 ns

module tCOUNTER;

    reg        i_CLK;
    reg        i_RESET_X;
    wire [7:0] i_COUNT;

    wire [7:0] i_HEX_1;
    wire [7:0] i_HEX_10;

    COUNTER dut (
        .COUNT  (i_COUNT),
        .CLK    (i_CLK),
        .RESET_X(i_RESET_X));

    HEXON7SEG dec_1 (
        .D   (i_COUNT[3:0]),
        .EN  (1'b1),
        .SEG (i_HEX_1));

    HEXON7SEG dec_10 (
        .D   (i_COUNT[7:4]),
        .EN  (1'b1),
        .SEG (i_HEX_10));

    initial begin
        i_CLK = 0;
        #5 forever #5 i_CLK = !i_CLK;
    end
  
    initial begin
        i_RESET_X = 1'b1;
        #2  i_RESET_X = 1'b0;
        #13 i_RESET_X = 1'b1;
        #5000 $stop;
    end
  
endmodule    
