#ifndef CFPGA_H_
#define CFPGA_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <cassert>  // assert()
#include <stdint.h> // uint??_t, int??_t
#include "cMpuIf.h" // MpuIf

namespace nbox {

    class Fpga {
    public:
        uint32_t baseaddr;
        uint32_t buswidth;
        MpuIf    *mpu;

        Fpga(uint32_t baseaddr, uint32_t buswidth) : 
            baseaddr(baseaddr), buswidth(buswidth), mpu(0)
        {
            assert(buswidth == 32 || buswidth == 16 || buswidth == 8);
        }
        virtual ~Fpga()
        {}
        void setMpu(MpuIf *mpu)
        {
            this->mpu = mpu;
        }
        bool readSuccess()
        {
            assert(mpu != 0);
            return mpu->readSuccess();
        }
        void nop(uint32_t clocks)
        {
            assert(mpu != 0);
            mpu->nop(clocks);
        }
    };

}

#endif
