#ifndef CMPU_H_
#define CMPU_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "cMpuIf.h" // MpuIf
#if defined(MPU_PIPE)
#   include "mimic_svdpi.h" // svLogicVecVal
#else
#   include "svdpi.h"       // svLogicVecVal
#endif

namespace nbox {

    class Mpu : virtual public MpuIf {
    public:
        static const uint32_t RESET_X;
    protected:
        const int     mpu_id;
        svLogicVecVal a;
        svLogicVecVal din;
        svLogicVecVal dout;
        svLogicVecVal ctrli;
        svLogicVecVal ctrlo;
        bool          read_success;

    protected:
        Mpu(int mpu_id);
    private:
        // privateかつ未定義にして、コピーと代入を禁止する
        Mpu(const Mpu &obj);
        Mpu &operator=(const Mpu &rhs);
    public:
        virtual ~Mpu();
        virtual int getId() const;
        virtual void startup();
        virtual bool reset();
        virtual bool reflect(
            svLogicVecVal       *a,
            svLogicVecVal       *dout,
            const svLogicVecVal *ctrli,
            svLogicVecVal       *ctrlo,
            int                  clk) = 0;

        virtual void reflect_din(
            const svLogicVecVal *din) = 0;

        virtual bool readSuccess() const;

        virtual void       nop(uint32_t clocks) = 0;
        virtual uint8_t  readB(uint32_t addr) = 0;
        virtual uint16_t readH(uint32_t addr) = 0;
        virtual uint32_t readW(uint32_t addr) = 0;
        virtual void    writeB(uint32_t addr, uint8_t  data) = 0;
        virtual void    writeH(uint32_t addr, uint16_t data) = 0;
        virtual void    writeW(uint32_t addr, uint32_t data) = 0;
    };

} // namespace nbox

#endif
