#ifndef CMPUFACTORYENLARGER_H_
#define CMPUFACTORYENLARGER_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "cMpu.h" // Mpu

namespace nbox {

    // Mpu工場を増築する、つまり、MpuFactoryクラスに対して、
    // 「Mpuの派生クラスのオブジェクトを作る関数」を登録するのを
    // 目的としたクラス
    class MpuFactoryEnlarger {
    public:
        MpuFactoryEnlarger(
            Mpu *(*func)(int mpu_id, const char *mpu_name));
    private:
        // privateかつ未定義にして、コピーと代入を禁止する
        MpuFactoryEnlarger(const MpuFactoryEnlarger &obj);
        MpuFactoryEnlarger &operator=(const MpuFactoryEnlarger &rhs);
    };

} // namespace nbox

#endif
