#ifndef CNAMEDPIPEIO_H_
#define CNAMEDPIPEIO_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <windows.h>  // HANDLE
#include "cChannel.h" // Channel

namespace nbox {

    class NamedPipeIo : public Channel {
    private:
        HANDLE hReadPipe;
        HANDLE hWritePipe;

        // privateかつ未定義にして、コピーと代入を禁止する
        NamedPipeIo(const NamedPipeIo &obj);
        NamedPipeIo &operator=(const NamedPipeIo &rhs);
    public:
        NamedPipeIo(const char *readpipe_name, const char *writepipe_name);
        virtual ~NamedPipeIo();
        virtual void read(void *buf, size_t len);
        virtual void write(const void *buf, size_t len);
        virtual void flush();
    protected:
        virtual void err_exit(const char *str);
        virtual void err_close_exit(const char *str);
    };

} // namespace nbox

#endif
