#ifndef INLINEUTIL_H_
#define INLINEUTIL_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <stdint.h> // uint32_t

namespace nbox {

    static inline bool negative_logic(uint32_t x)
    {
        return x ? false : true;
    }

    static inline unsigned int hton(unsigned int x)
    {
        return ((x & 0xffU) << 24) | ((x & 0xff00U) << 8)
            | ((x >> 8) & 0xff00U) | ((x >> 24) & 0xffU);
    }

} // namespace nbox

#endif
