#if !defined(NOODLYBOX_H_)
#define NOODLYBOX_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2008, molelord
// All rights reserved.

// ほかのヘッダにu32などがあらかじめ存在する場合、それを#includeした上で
// この直下のBITWIDTHTYPES_ARE_DEFINEDの行を有効にしてください。
//#define BITWIDTHTYPES_ARE_DEFINED 1

#if !defined(BITWIDTHTYPES_ARE_DEFINED)
#define BITWIDTHTYPES_ARE_DEFINED
typedef unsigned int   u32;
typedef unsigned short u16;
typedef unsigned char   u8;
typedef signed   int   s32;
typedef signed   short s16;
typedef signed   char   s8;
#endif

// シミュレータ操作用関数群
typedef struct Simulator {
    // ファイルを開いてそれをもとにFSMのコンフィグレーションを行う。
    // endOfConfigの前ならば何回でも呼び出すことができる。
    // 一度もconfigを呼び出さずにendOfConfigを呼び出した場合は、デフォルト
    // の動作をする。
    void (*config)(const char *filename);

    // コンフィグレーションの終了をFSMに伝える。
    void (*endOfConfig)(void);

    // 信号targetの値を、delayedナノ秒後にvalueに書き換える。
    void (*force)(const char *target, const char *value, u32 delayed);

    // 信号targetの値を読む。第一引数には結果保持用バッファのアドレスを与える。
    // 戻り値は常に、結果保持用バッファのアドレスとなる
    char *(*examine)(char *resultbuf, const char *target);

    // 生の文字列をFSMに渡す。
    void (*rawoutput)(const char *str);

    // 生の文字列をFSMから受け取る。第一引数には結果保持用バッファのアドレス
    // を与える。戻り値は常に、結果保持用バッファのアドレスとなる
    char *(*rawinput)(char *resultbuf);

    // シミュレーション終了要求をFSMに伝える。
    void (*endOfSimulation)(void);
} Simulator;

// メモリバス操作用関数群
typedef struct Processor {
    // clocks回のクロックの立ち上がりがあるまでプロセッサを停止する。
    // 時間待ちのために使用される。
    void (*nop)(u32 clocks);

    // 指定された時間だけ、プロセッサを停止する。
    // unitには"ms"または"us"または"ns"を指定できる。それ以外を指定した
    // 場合はassert()で異常終了する。
    void (*sleep)(u32 time, const char *unit);

    // 順に、8,16,32bitの値を読み出す。
    // もしデータバスの信号に不定やHi-Zがあったならば、返却値は
    // readBなら0xde, readHなら0xdead, readWなら0xdeadbeefになる。
    // 注：成功か失敗かを確実に知りたい場合はreadSuccess()を呼ぶこと。
     u8 (*readB)(u32 addr);
    u16 (*readH)(u32 addr);
    u32 (*readW)(u32 addr);

    // 直前のreadが正常なものであったならば、1が返却される。
    int (*readSuccess)(void);

    // 順に、8,16,32bitの値を書き込む。
    void (*writeB)(u32 addr,  u8 data);
    void (*writeH)(u32 addr, u16 data);
    void (*writeW)(u32 addr, u32 data);
} Processor;

#if defined(__cplusplus)
extern "C" {
#endif
Simulator *Simulator_instance(void);
Processor *Processor_instance(void);
#if defined(__cplusplus)
}
#endif

#endif
