source ../../tcl/noodlybox_util.tcl

silent [package require cmdline]
silent [set dbg 0]
silent [set starttime 0]

# Interpret all specified options.
proc interpretOptions {} {
    set specified ""

    global 1
    while {$::argc > 0} {
        append specified " " $1
        shift
    }

    putdbg "-- $specified --"

    while {[::cmdline::getopt specified {q t} optvar valvar]} {
        if {$optvar eq "q"} {
            onbreak { quit -force }
        } elseif {$optvar eq "t"} {
            set ::starttime [clock clicks -milliseconds]
            onbreak { puts stdout \
                "time : [expr [clock clicks -milliseconds] - $::starttime] ms"}
        }
    }
}

# main ----

interpretOptions

#                           dpi dll  top module
vsim -L unisims_ver -sv_lib c_side   tDPI

adjustgrid_by ../model/tDPI.v
add wave -r -hex /*
run 100 us
