#!/usr/bin/env ruby
if (ARGV.length < 3)
    print <<EOF
Usage : create_project.rb soft hdl projname
   ex : create_project.rb icarus verilog foobar
EOF
    exit 1
end

def isSystemVerilog(filename)
    # Search "DPI-C"
    #iChannel = [open $filename]
    #found = 0
    #while {1} {
    #    set rc [gets $iChannel line]
    #    if {$rc == -1} {
    #        break
    #    }
        # Ignore any comments
    #    regsub "//.*" $line "" line

    #    if {[regexp "\"DPI-C\"" $line]} {
    #        set found 1
    #    }
    #}
    #close(iChannel)
    #return found
end

def gatherFiles(hdl)
    result = []
    if (hdl == "verilog")
        result += Dir.glob(ENV['NOODLYBOX_HOME'] + "/model/*.v")
        result += Dir.glob("../model/*.v")
        result += Dir.glob(ENV['NOODLYBOX_HOME'] + "/sample/rtl/*.v")
    end
    return result
end

def create_icarusproj(hdl, projname)
    sources = gatherFiles(hdl)

    file = open(projname, "w")
    file.puts("-y $(XILINX)/verilog/src/unisims")
    for i in sources
        file.puts(i)
    end
    file.close()

    # dependency
    file = open(projname.sub(/\..*?$/, ".d"), "w")
    file.binmode
    file.print(projname.sub(/\..*?$/, ".out"), " :")
    for i in sources
        file.puts(" \\")
        file.print("  ", i)
    end
    file.puts("")
    file.close()
end

# main ----
soft     = ARGV[0]
hdl      = ARGV[1]
projname = ARGV[2]

if (soft == "icarus")
    create_icarusproj(hdl, projname)
end
