source $env(NOODLYBOX_HOME)/tcl/noodlybox_util.tcl

proc gatherFiles {hdl command command_sv} {
    global env

    if {$hdl eq "vhdl"} {
        foreach {i} [glob -type f -- \
            pkg/*.vhd \
            $env(NOODLYBOX_HOME)/model/*.vhd \
            ../model/*.vhd \
            $env(NOODLYBOX_HOME)/sample/rtl/*.vhd \
            ] {
            eval $command
        }
    } else {
        foreach {i} [glob -type f -- \
            $env(NOODLYBOX_HOME)/model/*.v \
            ../model/*.v \
            $env(NOODLYBOX_HOME)/sample/rtl/*.v \
            ] {
            if {[isSystemVerilog $i]} {
                eval $command_sv
            } else {
                eval $command
            }
        }
    }
}

proc create_msimproj {hdl projname} {
    project new . $projname
    set command    {project addfile $i}
    set command_sv {project addfile $i systemverilog "Top Level"}
    gatherFiles $hdl $command $command_sv

    project calculateorder
    project close

    if {$hdl eq "vhdl"} {
        set iChannel [open $projname.mpf]
        set oChannel [open tmp.mpf "w"]
        while {1} {
            set rc [gets $iChannel line]
            if {$rc == -1} {
                break
            }
            # for writing to the pipe immediately.
            regsub "^(UnbufferedOutput) = 0" $line {\1 = 1} line

            # check Project Settings - Display compiler output
            regsub "^(Echo_Compile_Output) = 0" $line {\1 = 1} line

            puts $oChannel $line
        }
        close $iChannel
        close $oChannel
        file rename -force -- tmp.mpf $projname.mpf
    }

    exit -force
}

# main ----
if [catch {
    set soft     [lindex $argv 0]
    set hdl      [lindex $argv 1]
    set projname [lindex $argv 2]

    if       {$soft eq "msim"} {
        create_msimproj $hdl $projname
    }
} errorKind ] {
    # Exception trap
    puts stderr $errorInfo
    error $errorKind
}
