-- SAMPLEFPGAのテストベンチ
library ieee;
use ieee.std_logic_1164.all;
use work.SH7751_PKG.all;
use work.SAMPLEFPGA_PKG.all;

entity tPIPE is
end;

architecture SIM of tPIPE is
    constant STEP      : time      := 16 ns;
    signal i_CLK       : std_logic := '0';
    signal i_RESET_X   : std_logic := '0';
    signal i_GPOUT     : std_logic_vector(15 downto 0);

    signal i_CS_X      : std_logic;
    signal i_OE_X      : std_logic;
    signal i_WE_X      : std_logic;
    signal i_BS_X      : std_logic;
    signal i_RDWR      : std_logic;
    signal i_A         : std_logic_vector(31 downto 0);
    signal i_D         : std_logic_vector(31 downto 0);


begin
    i_CLK <= not i_CLK after 8 ns;
    i_RESET_X <= '1' after 300 ns; -- モデルのDCMがロックするのを待つ

    uSH7751 : SH7751
        generic map (
            MPU_ID  => 0)
        port map (
            CS_X    => i_CS_X,
            OE_X    => i_OE_X,
            WE_X    => i_WE_X,
            BS_X    => i_BS_X,
            RDWR    => i_RDWR,
            A       => i_A,
            D       => i_D,
            CLK     => i_CLK,
            RESET_X => i_RESET_X);

    -- Device Under Verification
    uDUV : SAMPLEFPGA
        port map (
            CS_X    => i_CS_X,
            BS_X    => i_BS_X,
            RDWR    => i_RDWR,
            A       => i_A(7 downto 0),
            D       => i_D(15 downto 0),
            GPOUT   => i_GPOUT,
            CLK     => i_CLK,
            RESET_X => i_RESET_X);
end;
