source ../../tcl/noodlybox_util.tcl

if {[info exist hdl] eq 0} {
    source s
}

silent [package require cmdline]
silent [set dbg 0]
silent [set starttime 0]

# Interpret all specified options.
proc interpretOptions {} {
    set specified ""

    global 1
    while {$::argc > 0} {
        append specified " " $1
        shift
    }

    putdbg "-- $specified --"

    while {[::cmdline::getopt specified {q t} optvar valvar]} {
        if {$optvar eq "q"} {
            onbreak { quit -force }
        } elseif {$optvar eq "t"} {
            set ::starttime [clock clicks -milliseconds]
            onbreak { puts stdout \
                "time : [expr [clock clicks -milliseconds] - $::starttime] ms"}
        }
    }
}

# main ----

exec ./c_side_pipe 0 SH7751 &

# c_side_pipe.exepCvt@C܂ł́Aԑ҂
after [expr 1 * 1000]

interpretOptions

if {$hdl eq "vhdl"} {
    #    top module
    vsim tPIPE
    adjustgrid_by ../model/tPIPE.vhd
    when -label atEndOfSim { /tpipe/ush7751/umpu/endofsim == 1 } { stop }
} else {
    #                   top module
    vsim -L unisims_ver tPIPE
    adjustgrid_by ../model/tPIPE.v
}

add wave -r -hex /*
run 100 us
