-- SAMPLEFPGAのテストベンチ
library ieee;
use ieee.std_logic_1164.all;
use work.NOODLYBOX_PKG.all;
use work.SAMPLEFPGA_PKG.all;

entity tSAMPLEFPGA is
end;

architecture SIM of tSAMPLEFPGA is
    signal CS_X      : std_logic;
    signal OE_X      : std_logic;
    signal WE_X      : std_logic;
    signal BS_X      : std_logic;
    signal RDWR      : std_logic;
    signal A         : std_logic_vector(31 downto 0);
    signal D         : std_logic_vector(31 downto 0);
    signal CLK       : std_logic := '0';
    signal RESET_X   : std_logic := '0';

    signal GPOUT     : std_logic_vector(15 downto 0);

begin
    CLK <= not CLK after 8 ns;
    RESET_X <= '1' after 300 ns; -- モデルのDCMがロックするのを待つ

    uBOX : NOODLYBOX
        generic map (
            CLOCK_PERIOD => 16 ns)
        port map (
            CS_X    => CS_X,
            OE_X    => OE_X,
            WE_X    => WE_X,
            BS_X    => BS_X,
            RDWR    => RDWR,
            A       => A,
            D       => D,
            CLK     => CLK,
            RESET_X => RESET_X);

    -- Device Under Verification
    uDUV : SAMPLEFPGA
        port map (
            CS_X    => CS_X,
            BS_X    => BS_X,
            RDWR    => RDWR,
            A       => A(7 downto 0),
            D       => D(15 downto 0),
            GPOUT   => GPOUT,
            CLK     => CLK,
            RESET_X => RESET_X);
end;
