--  P:\HDL\NOODLYBOX\RTL\ACCESS_SM.vhd
--  VHDL code created by Xilinx's StateCAD 9.2i
--  Sun Jul 27 11:16:26 2008

--  This VHDL code (for use with Xilinx XST) was generated using: 
--  enumerated state assignment with structured code format.
--  Minimization is enabled,  implied else is enabled, 
--  and outputs are manually optimized.

LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY ACCESS_SM IS
	PORT (CLK,BS_X,CS_X,RDWR,RESET_X: IN std_logic;
		ADDR_VALID,OE,WE : OUT std_logic);
END;

ARCHITECTURE BEHAVIOR OF ACCESS_SM IS
	TYPE type_sreg IS (GET,IDLE,PUT);
	SIGNAL sreg, next_sreg : type_sreg;
	SIGNAL next_ADDR_VALID,next_OE,next_WE : std_logic;
BEGIN
	PROCESS (CLK, RESET_X, next_sreg, next_ADDR_VALID, next_OE, next_WE)
	BEGIN
		IF ( RESET_X='0' ) THEN
			sreg <= IDLE;
			OE <= '0';
			WE <= '0';
			ADDR_VALID <= '1';
		ELSIF CLK='1' AND CLK'event THEN
			sreg <= next_sreg;
			ADDR_VALID <= next_ADDR_VALID;
			OE <= next_OE;
			WE <= next_WE;
		END IF;
	END PROCESS;

	PROCESS (sreg,BS_X,CS_X,RDWR)
	BEGIN
		next_ADDR_VALID <= '0'; next_OE <= '0'; next_WE <= '0'; 

		next_sreg<=GET;

		CASE sreg IS
			WHEN GET =>
				next_sreg<=IDLE;
				next_WE<='0';
				next_OE<='0';
				next_ADDR_VALID<='1';
			WHEN IDLE =>
				IF ( CS_X='1' ) OR ( BS_X='1' ) THEN
					next_sreg<=IDLE;
					next_WE<='0';
					next_OE<='0';
					next_ADDR_VALID<='1';
				END IF;
				IF ( CS_X='0' AND BS_X='0' AND RDWR='1' ) THEN
					next_sreg<=PUT;
					next_WE<='0';
					next_ADDR_VALID<='0';
					next_OE<='1';
				END IF;
				IF ( CS_X='0' AND BS_X='0' AND RDWR='0' ) THEN
					next_sreg<=GET;
					next_OE<='0';
					next_ADDR_VALID<='0';
					next_WE<='1';
				END IF;
			WHEN PUT =>
				next_sreg<=IDLE;
				next_WE<='0';
				next_OE<='0';
				next_ADDR_VALID<='1';
			WHEN OTHERS =>
		END CASE;
	END PROCESS;
END BEHAVIOR;
