# This software is a part of NOODLYBOX.
# This software is distributed under the terms of the new BSD License.
# Copyright (c) 2009, molelord
# All rights reserved.

# echo canceller
proc silent args {
}

# Put the debug information.
proc putdbg {str} {
    if {$::dbg} { puts stderr $str }
}

proc isSystemVerilog {filename} {
    # Search "DPI-C"
    set iChannel [open $filename]
    set found 0
    while {1} {
        set rc [gets $iChannel line]
        if {$rc == -1} {
            break
        }
        # Ignore any comments
        regsub "//.*" $line "" line

        if {[regexp "\"DPI-C\"" $line]} {
            set found 1
        }
    }
    close $iChannel
    return $found
}

proc adjustgrid_by {filename} {
    set iChannel [open $filename]
    set match  0
    set period 0
    while {1} {
        set rc [gets $iChannel line]
        if {$rc == -1} {
            break
        }
        # Ignore any comments
        regsub "//.*" $line "" line

        # Searching clock period
        # for Verilog HDL
        if {[regexp "localparam.*STEP.*?(\\d+)" $line ignore match]} {
            putdbg "-- gridperiod : $match --"
        }
        # for VHDL
        if {[regexp "constant.*STEP.*?(\\d+)" $line ignore match]} {
            putdbg "-- gridperiod : $match --"
        }
    }
    close $iChannel

    if {$match} {
        set full $match
        set half [expr $full / 2]
        append full "ns"
        append half "ns"
        configure wave -gridoffset $half -gridperiod $full -timeline 1
    }
}
