/*
 * Decompiled with CFR 0.152.
 */
package nor.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.MatchResult;
import nor.core.plugin.PluginAdapter;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.MessageHandlerAdapter;
import nor.http.HeaderName;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.util.io.Stream;
import nor.util.log.Logger;

public class HttpsConnector
extends PluginAdapter {
    private String urlRegex = null;
    private Map<String, String> redirects = null;
    private static final Logger LOGGER = Logger.getLogger(HttpsConnector.class);

    public void init(File common, File local) throws IOException {
        LOGGER.entering("init", new Object[]{common, local});
        if (!common.exists()) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("hosts.default");
            FileOutputStream out = new FileOutputStream(common);
            Stream.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            in.close();
        }
        Properties prop = new Properties();
        FileReader r = new FileReader(common);
        prop.load(r);
        ((Reader)r).close();
        if (local.exists()) {
            Properties localProp = new Properties();
            FileReader localIn = new FileReader(local);
            localProp.load(localIn);
            ((Reader)localIn).close();
            prop.putAll((Map<?, ?>)localProp);
        }
        if (prop.size() != 0) {
            this.redirects = new HashMap<String, String>();
            StringBuilder regex = new StringBuilder();
            regex.append("http://(");
            for (Object key : prop.keySet()) {
                String host = key.toString();
                regex.append(this.toRegex(host));
                regex.append("|");
                this.redirects.put(host, prop.getProperty(host));
            }
            regex.setLength(regex.length() - 1);
            regex.append(")(.*)");
            this.urlRegex = regex.toString();
        }
        LOGGER.exiting("init");
    }

    public MessageHandler[] messageHandlers() {
        LOGGER.entering("messageHandlers", new Object[0]);
        MessageHandler[] res = null;
        if (this.urlRegex != null) {
            res = new MessageHandler[]{new MessageHandlerAdapter(this.urlRegex){

                public HttpResponse doRequest(HttpRequest request, MatchResult url) {
                    LOGGER.entering(((Object)((Object)this)).getClass(), "doRequest", new Object[]{request, url});
                    String host = url.group(1);
                    String path = url.group(2);
                    HttpResponse res = request.createResponse(Status.Found);
                    String new_host = (String)HttpsConnector.this.redirects.get(host);
                    if (path != null) {
                        res.getHeader().set(HeaderName.Location, String.format("https://%s%s", new_host, path));
                    } else {
                        res.getHeader().set(HeaderName.Location, String.format("https://%s", new_host));
                    }
                    LOGGER.exiting(((Object)((Object)this)).getClass(), "doRequest", (Object)res);
                    return res;
                }
            }};
        }
        LOGGER.exiting("messageHandlers", res);
        return res;
    }

    private String toRegex(String str) {
        return str.toString().replace(".", "\\.").replace("*", "[^/]*").replace("(", "(?:");
    }
}

