#include "../../bootpack.h"

void Vesa::init(void *vram, int xSize, int ySize)
{
	vram_ = reinterpret_cast<color_16*>(vram);
	xSize_ = xSize;
	ySize_ = ySize;
}

void Vesa::WritePoint(int x, int y, color_16 color)
{
	vram_[xSize_ * y + x] = color;
}

color_16 Vesa::GetPoint(int x, int y)
{
	return vram_[xSize_ * y + x];
}

void Vesa8::init(void *vram, int xSize, int ySize)
{
	vram_ = reinterpret_cast<byte*>(vram);
	xSize_ = xSize;
	ySize_ = ySize;
}

void Vesa8::WritePoint(int x, int y, color_16 color)
{
	byte r = ((color & 0xf800) >> 8) / 51;
	byte g = ((color & 0x07e0) >> 3) / 51;
	byte b = ((color & 0x001f) << 3) / 51;
	vram_[xSize_ * y + x] = r + 6 * g + 36 * b;
}

color_16 Vesa8::GetPoint(int x, int y)
{
	byte col = vram_[xSize_ * y + x];
	byte r = col / 36;
	col -= r * 36;
	byte g = col / 6;
	col -= r * 6;
	byte b = col;
	return (r << 8) & 0xf800 | (g << 3) & 0x07e0 | (b >> 3) & 0x001f;
}
