#include "../bootpack.h"


void GDT::SetSegmDesc(SegmentDescriptor *sd, unsigned int limit, unsigned int base, unsigned int ar)
{
	if (limit > 0xfffff) {
		ar |= 0x8000; // G_bit = 1
		limit /= 0x1000; // G_bit1ɂƁA~bg4096{B
	}
	sd->limitLow    = limit & 0xffff;
	sd->baseLow     = base & 0xffff;
	sd->baseMid     = (base >> 16) & 0xff;
	sd->accessRight = ar & 0xff;
	sd->limitHigh   = ((limit >> 16) & 0x0f) | ((ar >> 8) & 0xf0);
	sd->baseHigh    = (base >> 24) & 0xff;
}

SegmentDescriptor *GDT::gdt = (SegmentDescriptor *)ADR_GDT;
void GDT::init()
{
	int i;
	for (i = 0; i < 8192; i++) {
		GDT::SetSegmDesc(gdt + i, 0, 0, 0);
	}
	GDT::SetSegmDesc(gdt + 1, 0xffffffff, 0x00000000, AR_DATA32_RW);
	GDT::SetSegmDesc(gdt + 2, LIMIT_BOTPAK, ADR_BOTPAK, AR_CODE32_ER);
	//load_gdtr(LIMIT_GDT, ADR_GDT);
	gdtr.load(LIMIT_GDT, ADR_GDT);
}

void IDT::SetGateDesc(GateDescriptor *gd, unsigned int offset, unsigned int selector, unsigned int ar)
{
	gd->offsetLow = offset & 0xffff;
	gd->selector = selector;
	gd->dwCount = (ar >> 8) & 0xff;
	gd->accessRight = ar & 0xff;
	gd->offsetHigh = (offset >> 16) & 0xffff;
}

GateDescriptor *IDT::idt = (GateDescriptor *)ADR_IDT;
void IDT::init()
{
	int i;
	//for (i = 0; i < 256; i++) {
	for (i = 0; i < 128; i++) {
		IDT::SetGateDesc(idt + i, 0, 0, 0);
	}
	//load_idtr(LIMIT_IDT, ADR_IDT);
	idtr.load(LIMIT_IDT, ADR_IDT);
//	IDT::SetGateDesc(idt + 0x0c, (int) asm_inthandler0c, 2 * 8, AR_INTGATE32);
//	IDT::SetGateDesc(idt + 0x0d, (int) asm_inthandler0d, 2 * 8, AR_INTGATE32);
	IDT::SetGateDesc(idt + 0x20, (int) asm_inthandler20, 2 * 8, AR_INTGATE32);
	IDT::SetGateDesc(idt + 0x21, (int) asm_inthandler21, 2 * 8, AR_INTGATE32);
	IDT::SetGateDesc(idt + 0x27, (int) asm_inthandler27, 2 * 8, AR_INTGATE32);
	IDT::SetGateDesc(idt + 0x2c, (int) asm_inthandler2c, 2 * 8, AR_INTGATE32);
//	IDT::SetGateDesc(idt + 0x40, (int) asm_nos_api     , 2 * 8, AR_INTGATE32 + 0x60);
}

