#ifndef SHEET_H_
#define SHEET_H_

namespace system {
	class SheetController;
	
	/*
	 * V[g
	 */
	class Sheet {
		// 萔
		static const dword FLAG_UNUSED = 0;
		static const dword FLAG_USED = 1;
		
		Picture pict_;
		dword flags_;
		int xpos_, ypos_, height_;
		color_16 col_inv_; // ߐF
		
		bool mouse_;
		bool fixed_;
		
		void set_mouse(bool mouse) { mouse_ = mouse; }
		bool get_mouse() { return mouse_; }
	public:
		explicit Sheet();
		void init(int xsize, int ysize) { pict_.init(xsize, ysize); }
		
		// gp}[Nt
		void use() { flags_ = FLAG_USED; }
		
		// gp}[Nt
		void release() { flags_ = FLAG_UNUSED; }
		
		// gpǂ
		bool used() const { return flags_ == FLAG_USED; }
		
		// ݒ肷
		void set_height(int height) { height_ = height; }
		
		// 擾
		int get_height() const { return height_; }
		
		// 摜obt@擾
		Picture* get_buffer() { return &pict_; }
		
		// 摜obt@擾
		const Picture* get_buffer() const { return &pict_; }
		
		// ߐFݒ
		void set_invisible_color(color_16 color) { col_inv_ = color; }
		
		// ߐF擾
		color_16 get_invisible_color() const { return col_inv_; }
		
		// Œ肷邩ǂݒ
		void set_fix(bool fixed) { fixed_ = fixed; }
		
		// Œ肩ǂ
		bool fixed() { return fixed_; }
		
		// ʒuݒ
		void set_xpos(int xpos) { xpos_ = xpos; }
		void set_ypos(int ypos) { ypos_ = ypos; }
		
		// ʒu擾
		int get_xpos() const { return xpos_; }
		int get_ypos() const { return ypos_; }
		friend class SheetController;
	};
	
	/*
	 * V[gRg[
	 */
	class SheetController {
		Sheet* sheets0_; // V[g̎̂i[
		Sheet** sheets_; // V[gւ̃|C^i[
		Picture map_; // }EXL}bv
		Picture map_nomouse_; // }EX}bv
		
		bool exist_mouse_; // }EX̃V[g݂邩
		int* taskids_;
		
		int top_; // gbv̍
		
		/*
		 * ̈L
		 */
		//void expand();
		
	public:
		// 萔
		static const int MAX_SHEETS = 256; // őV[g

		explicit SheetController();
		~SheetController();
		
		Sheet* alloc(int taskid = -1, bool mouse = false);
		void free(Sheet* sht);
		
		void updown(Sheet* sht, int new_height);
		void updown(int old_height, int new_height);
		
		// V[g̒̎w肵͈͂ĕ`
		void refresh(const Sheet* sht, int x0, int y0, int x1, int y1);
		
		// V[g̒̎w肵͈͂ĕ`
		void refresh_winframe(const Sheet* sht);
		
		// w肵ʂ͈̔͂Aw肵͈̔͂ɂčĕ`
		void refresh_sub(int x0, int y0, int x1, int y1, int h0, int h1);
		
		// }bvĕ`
		void refresh_map(int x0, int y0, int x1, int y1, int h0);
		
		// w肵ʂ͈̔͂Aw肵͈̔͂ɂčĕ`
		void refresh_sub_dragframe(int x0, int y0, int x1, int y1, int h0, int h1);
		
		// }bvĕ`
		void refresh_map_dragframe(int x0, int y0, int x1, int y1, int h0);
		
		// V[g㉺EɈړ
		void slide(Sheet* sht, int xpos, int ypos);
		
		// hbOg㉺EɈړ
		void slide_dragframe(Sheet* sht, int xpos, int ypos);
		
		// w肵W̃V[gID擾
		int get_sheetid(int x, int y);
		int get_sheetid_test(int x, int y);
		
		// w肵V[g̃V[gID擾
		int get_sheetid(Sheet* sht);
		
		// w肵̃V[gID擾
		int get_sheetid(int height);
		
		// w肵V[gID̃V[g擾
		Sheet* get_sheet(int sheetid);
		
		// w肵V[gID̃^XNID擾
		int get_taskid(int sheetid);
		
		// w肵V[g̃^XNID擾
		int get_taskid(Sheet* sht) { return get_taskid(sht - sheets0_); }
	};
	
	// w肵^XNID̃V[g擾
	Sheet* get_sheet_taskid(int taskid);
}

#endif /*SHEET_H_*/
