#include "../bootpack.h"

void box(Picture* buf, int x0, int y0, int x1, int y1, color_16 color);

const char Window::closebtn_[CLOSE_YSIZE][CLOSE_XSIZE + 1] = {
	"OO@@@@@@@@@@@@@@@@@OO",
	"O@a000000000000000a@O",
	"@a11111111111111111a@",
	"@0111111111111111110@",
	"@0112222222222222110@",
	"@01120$3333333$02110@",
	"@0112$$$33333$$$2110@",
	"@01123$$$333$$$32110@",
	"@011233$$$3$$$332110@",
	"@0112333$$$$$3332110@",
	"@01123333$$$33332110@",
	"@0112333$$$$$3332110@",
	"@011233$$$3$$$332110@",
	"@01123$$$333$$$32110@",
	"@0112$$$88888$$$2110@",
	"@01120$7777777$02110@",
	"@0112666666666662110@",
	"@0000555555555550000@",
	"@b44444444444444444b@",
	"O@b999999999999999b@O",
	"OO@@@@@@@@@@@@@@@@@OO",
};

const char Window::closebtn_noact_[CLOSE_YSIZE][CLOSE_XSIZE + 1] = {
	"@@@@@@@@@@@@@@@@@@@@@",
	"@@00000000000000000@@",
	"@0011111111111111100@",
	"@0111111111111111110@",
	"@0111111111111111110@",
	"@01112$1111111$21110@",
	"@0111$$$11111$$$1110@",
	"@01111$$$111$$$11110@",
	"@011111$$$1$$$111110@",
	"@0111111$$$$$1111110@",
	"@01111111$$$11111110@",
	"@0111111$$$$$1111110@",
	"@011111$$$1$$$111110@",
	"@01111$$$111$$$11110@",
	"@0111$$$11111$$$1110@",
	"@01112$1111111$21110@",
	"@0111111111111111110@",
	"@0111111111111111110@",
	"@0011111111111111100@",
	"@@00000000000000000@@",
	"@@@@@@@@@@@@@@@@@@@@@",
};

void Window::make(Sheet* sht, bool active) {
	static const char round[6][6 + 1] = {
		".....b",
		"...bb*",
		"..b**@",
		".b*@@@",
		".b*@@@",
		"b*@@@@",
	};
	Picture* buf = sht->get_buffer();
	const int xsize = buf->get_xsize();
	const int ysize = buf->get_ysize();
	int x, y;
	color_32 c;
	color_16 c_inv;
	if (active) {
		box(buf, 2,  2, xsize - 3,  3, convC(0x67737c));
		box(buf, 2,  4, xsize - 3,  5, convC(0x626e78));
		box(buf, 2,  6, xsize - 3,  7, convC(0x5c6974));
		box(buf, 2,  8, xsize - 3,  9, convC(0x5a6773));
		box(buf, 2, 10, xsize - 3, 11, convC(0x556271));
		box(buf, 2, 12, xsize - 3, 13, convC(0x4b5767));
		box(buf, 2, 14, xsize - 3, 15, convC(0x334152));
		box(buf, 2, 16, xsize - 3, 17, convC(0x313e4f));
		box(buf, 2, 18, xsize - 3, 19, convC(0x2d394a));
		box(buf, 2, 20, xsize - 3, 21, convC(0x2a3446));
		box(buf, 2, 22, xsize - 3, 23, convC(0x273142));
		box(buf, 2, 24, xsize - 3, 25, convC(0x242d3e));
		box(buf, 3, 26, xsize - 3, 27, convC(0x232a3d));
		box(buf, 3, 28, xsize - 3, 28, convC(0x161d2d));
		box(buf, 0,         0,         xsize - 1,         0, convC(0x161d2d));
		box(buf, 0,         0,         0,         ysize - 1, convC(0x161d2d));
		box(buf, 0,         ysize - 1, xsize - 1, ysize - 1, convC(0x161d2d));
		box(buf, xsize - 1, 0,         xsize - 1, ysize - 1, convC(0x161d2d));
	
		box(buf, 1,         1,         xsize - 2,         1, convC(0x747c85));
		box(buf, 1,         1,         1,         ysize - 2, convC(0x747c85));
		box(buf, 1,         ysize - 2, xsize - 2, ysize - 2, convC(0x747c85));
		box(buf, xsize - 2, 1,         xsize - 2, ysize - 2, convC(0x747c85));
	
		box(buf, 2,         24,        xsize - 3, 24,        convC(0x161d2d));
		box(buf, 2,         24,        2,         ysize - 3, convC(0x161d2d));
		box(buf, 2,         ysize - 3, xsize - 3, ysize - 3, convC(0x161d2d));
		box(buf, xsize - 3, 24,        xsize - 3, ysize - 3, convC(0x161d2d));
		c_inv = sht->get_invisible_color();
		for (y = 0; y < 6; y++) {
			for (x = 0; x < 6; x++) {
				if (round[y][x] == '.') {
					buf->point(            x,             y, c_inv);
					buf->point(xsize - x - 1,             y, c_inv);
				} else if (round[y][x] == 'b') {
					buf->point(            x,             y, convC(0x161d2d));
					buf->point(xsize - x - 1,             y, convC(0x161d2d));
				} else if (round[y][x] == '*') {
					buf->point(            x,             y, convC(0x747c85));
					buf->point(xsize - x - 1,             y, convC(0x747c85));
				}
			}
		}
		for (y = 0; y < CLOSE_YSIZE; y++) {
			for (x = 0; x < CLOSE_XSIZE; x++) {
				if (closebtn_[y][x] == '@') { c = 0x161d2d; }
				else if (closebtn_[y][x] == '0') { c = 0xec8069; }
				else if (closebtn_[y][x] == '1') { c = 0xf52800; }
				else if (closebtn_[y][x] == '2') { c = 0xd12d13; }
				else if (closebtn_[y][x] == '3') { c = 0xd32b10; }
				else if (closebtn_[y][x] == '4') { c = 0xf6886d; }
				else if (closebtn_[y][x] == '5') { c = 0xf77655; }
				else if (closebtn_[y][x] == '6') { c = 0xf46740; }
				else if (closebtn_[y][x] == '7') { c = 0xe95132; }
				else if (closebtn_[y][x] == '8') { c = 0xe34123; }
				else if (closebtn_[y][x] == '9') { c = 0xf9ae9b; }
				else if (closebtn_[y][x] == 'a') { c = 0xb08795; }
				else if (closebtn_[y][x] == 'b') { c = 0x8b829a; }
				else if (closebtn_[y][x] == '$') { c = 0xffffff; }
				else { c = c_inv; }
				if (c != c_inv) {
					if (y + 5 < 14) {
						c = mixC(c, 0xffffff, 80, 20);
					} else {
						c = convC(c);
					}
					buf->point(xsize - 26 + x, y + 5, c);
				}
			}
		}
	} else {
		box(buf, 2,  2, xsize - 3,  6, convC(0x111929));
		box(buf, 2,  7, xsize - 3,  7, convC(0x111828));
		box(buf, 2,  8, xsize - 3,  9, convC(0x101726));
		box(buf, 2, 10, xsize - 3, 11, convC(0x101625));
		box(buf, 2, 12, xsize - 3, 12, convC(0x0f1624));
		box(buf, 2, 13, xsize - 3, 14, convC(0x0e1421));
		box(buf, 2, 15, xsize - 3, 28, convC(0x080c13));
		box(buf, 0,         0,         xsize - 1,         0, convC(0x030406));
		box(buf, 0,         0,         0,         ysize - 1, convC(0x030406));
		box(buf, 0,         ysize - 1, xsize - 1, ysize - 1, convC(0x030406));
		box(buf, xsize - 1, 0,         xsize - 1, ysize - 1, convC(0x030406));
	
		box(buf, 1,         1,         xsize - 2,         1, convC(0x363c44));
		box(buf, 1,         1,         1,         ysize - 2, convC(0x363c44));
		box(buf, 1,         ysize - 2, xsize - 2, ysize - 2, convC(0x363c44));
		box(buf, xsize - 2, 1,         xsize - 2, ysize - 2, convC(0x363c44));
	
		box(buf, 2,         24,        xsize - 3, 24,        convC(0x080c13));
		box(buf, 2,         24,        2,         ysize - 3, convC(0x080c13));
		box(buf, 2,         ysize - 3, xsize - 3, ysize - 3, convC(0x080c13));
		box(buf, xsize - 3, 24,        xsize - 3, ysize - 3, convC(0x080c13));
		c_inv = sht->get_invisible_color();
		for (y = 0; y < 6; y++) {
			for (x = 0; x < 6; x++) {
				if (round[y][x] == '.') {
					buf->point(            x,             y, c_inv);
					buf->point(xsize - x - 1,             y, c_inv);
				} else if (round[y][x] == 'b') {
					buf->point(            x,             y, convC(0x030406));
					buf->point(xsize - x - 1,             y, convC(0x030406));
				} else if (round[y][x] == '*') {
					buf->point(            x,             y, convC(0x363c44));
					buf->point(xsize - x - 1,             y, convC(0x363c44));
				}
			}
		}
		for (y = 0; y < CLOSE_YSIZE; y++) {
			for (x = 0; x < CLOSE_XSIZE; x++) {
				if (closebtn_noact_[y][x] == '@') { c = 0x010409; }
				else if (closebtn_noact_[y][x] == '0') { c = 0x2c3b4e; }
				else if (closebtn_noact_[y][x] == '1') { c = 0x00091c; }
				else if (closebtn_noact_[y][x] == '2') { c = 0x999da4; }
				else if (closebtn_noact_[y][x] == '$') { c = 0xffffff; }
				else { c = c_inv; }
				if (c != c_inv) {
					c = convC(c);
					buf->point(xsize - 26 + x, y + 5, c);
				}
			}
		}
	}
}

void box(Picture* buf, int x0, int y0, int x1, int y1, color_16 color) {
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++) {
			if (buf->get_color(x, y) != 0xffff) {
				buf->point(x, y, color);
			}
		}
	}
}
