#ifndef BOOTPACK_H_
#define BOOTPACK_H_

extern"C" void BitNosMain(); /* C̓ */
int BitNosMainCpp(); /* C++̓ */

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;
typedef unsigned int size_t;

#define NULL 0

#define DEBUG_MESSAGE

// DRAG_FRAME  1:\  2:g
#define DRAG_FRAME 2

// 萔`
const dword ADR_BOOTINFO = 0x900;
const dword ADR_DISKIMG = 0x00100000;


extern "C" {
	// ptHg
	extern byte serif[256 * 16];
	// ptHg
	extern byte gothic[256 * 16];
	// ~jtHg
	extern byte minifnt[256 * 12];
}

#include "naskfunc.h"
#include "std/deque.h"
#include "std/queue.h"
#include "driver/video/video.h"
#include "driver/video/vesa.h"
#include "driver/io/io.h"
#include "driver/io/eflags.h"
#include "driver/io/cr0.h"
#include "driver/io/gdtr.h"
#include "driver/io/tr.h"
#include "driver/pic/pic.h"
#include "driver/keyboard/keyboard.h"
#include "driver/mouse/mouse.h"
#include "driver/pit/pit.h"
#include "driver/rtc/rtc.h"
#include "driver/fat12/fat12.h"
#include "system/arraylist.h"
#include "system/memory.h"
#include "system/bootinfo.h"
#include "system/desctable.h"
#include "system/font.h"
#include "system/graphic.h"
#include "system/int.h"
#include "system/message.h"
#include "system/sheet.h"
#include "system/timer.h"
#include "system/debugwindow.h"
#include "system/window.h"
#include "system/mtask.h"
#include "system/systemtask.h"
#include "system/time.h"
#include "system/console.h"
#include "system/file.h"
#include <string.h>
#include <stdio.h>


using namespace system;
using namespace driver;
using namespace std;

extern Font* font_hankaku;
extern Font* font_gothic;
extern Font* font_serif;
extern Font* font_mini;
extern Screen* g_screen;
#ifndef DEBUG_MESSAGE
extern queue<Message*>* task1_fifo;
#else
extern queue<Message>* task1_fifo;
#endif
extern TimerController* g_timerctl;
extern SheetController* g_shtctl;
extern Sheet* g_sheet_back;
extern TaskController* g_taskctl;
extern dword memory_size;


extern DebugWindow* dbg;

void putstr_sht(Sheet* sht, int x, int y, const char* str, color_16 color,
	color_16 bgcolor, Font* font = font_hankaku);
void box_sht(Sheet* sht, int x0, int y0, int x1, int y1, color_16 color);

/*
 * fobOp֐
 */
//void dbg(const char* const msg);

#endif
