#include "../../bootpack.h"

int* FAT12::fat;


void FAT12::init() {
	byte* img = (byte*) (ADR_DISKIMG + 0x000200); // FAT
	fat = new int[2880];
	
	// FAT̉
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		fat[i + 0] = (img[j + 0]      | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
}

FileEntry* FAT12::load(const char* name) {
	char filename[12];
	FileInfo* finfo = (FileInfo*) (ADR_DISKIMG + 0x002600);
	int i, j;
	for (i = 0; i < 11; i++) {
		filename[i] = ' ';
	}
	filename[i] = '\0';
	i = 0;
	
	// "FNAME   EXT" ̌`ɕϊ
	for (j = 0; name[j] != '\0' && i < 11; j++) {
		if (name[j] == '.') {
			i = 8;
		} else {
			filename[i] = name[j];
			if ('a' <= filename[i] && filename[i] <= 'z') {
				filename[i] -= 0x20;
			}
			i++;
		}
	}
	for (i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00) {
			// t@C͂ȍ~ɂ͖
			break;
		}
		if ((finfo[i].type & 0x18) == 0) {
			if (strncmp((char*)finfo[i].name, filename, 11) == 0) {
				break;
			}
		}
	}
	if (i < 224 && finfo[i].name[0] != 0x00) {
		// t@C
		return load(finfo + i);
	}
	return NULL;
}

FileEntry* FAT12::load(const FileInfo* info) {
	byte* img = (byte*) (ADR_DISKIMG + 0x003e00); // f[^̊Jnꏊ
	FileEntry* entry = new FileEntry();
	if (info->name[0] != 0x00 && info != NULL) {
		int size = info->size, clustno = info->clustno;
		int i;
		entry->init((char*)info->name, info->size);
		byte* buf = entry->get_buffer();
		for (;;) {
			if (size <= 512) {
				for (i = 0; i < size; i++) {
					buf[i] = img[clustno * 512 + i];
				}
				return entry;
			} else {
				for (i = 0; i < 512; i++) {
					buf[i] = img[clustno * 512 + i];
				}
				size -= 512;
				buf += 512;
				clustno = fat[clustno];
			}
		}
	}
	return NULL;
}
