#include "../../bootpack.h"

std::queue<int>* driver::g_keycmd;

const int Keyboard::KEYCMD_LED;

void Keyboard::wait_sendready() {
	IO8 key_status(Keyboard::PORT_KEYSTA);
	while(1)
	{
		if ( (key_status.in() &
			Keyboard::KEYSTA_SEND_NOTREADY) == 0) {
			break;
		}
	}
}

void Keyboard::init() {
	IO8 key_command(Keyboard::PORT_KEYCMD);
	IO8 key_data(Keyboard::PORT_KEYDAT);
	g_keycmd = new queue<int>(32);
	wait_sendready();
	key_command << Keyboard::KEYCMD_WRITE_MODE;
	wait_sendready();
	key_data << Keyboard::KBC_MODE;
}

void Keyboard::out(int cmd, int data) {
	io_cli();
	g_keycmd->push(cmd);
	g_keycmd->push(data);
	io_sti();
}
