#include "../../bootpack.h"

/*
 * statico
 */
bool Mouse::scroll_ = false;
MouseDecode Mouse::mdec;

void Mouse::init_cursor(system::Picture* cursor) {
	static const char mcursor1[YSIZE][XSIZE + 1] = {
		"*___________",
		"**__________",
		"*.*_________",
		"*..*________",
		"*...*_______",
		"*....*______",
		"*.....*_____",
		"*......*____",
		"*.......*___",
		"*........*__",
		"*.........*_",
		"*......*****",
		"*...*..*____",
		"*..**..*____",
		"*.*__*..*___",
		"**___*..*___",
		"*_____*..*__",
		"______*..*__",
		"_______*..*_",
		"_______*..*_",
		"________***_",
	};
	int y, x;
	for (y = 0; y < YSIZE; y++) {
		for (x = 0; x < XSIZE; x++) {
			if (mcursor1[y][x] == '*') {
				cursor->point(x, y, 0x0000);
			} else if (mcursor1[y][x] == '.') {
				cursor->point(x, y, 0xffff);
			} else {
				cursor->point(x, y, 0x0001);
			}
		}
	}
}

void Mouse::enable(system::Task* task) {
	Message msg;
	int i = 0;
	int errors = 0; // G[̉
	bool send = false; // }EX֑Mtrue
	queue<Message>* fifo = task->fifo();
	int keycmd_wait = -1, port = 0;
	IO8 keydat(Keyboard::PORT_KEYDAT);
	IO8 keycmd(Keyboard::PORT_KEYCMD);
	
	out(0xf3);
	out(200);
	out(0xf3);
	out(100);
	out(0xf3);
	out(80);
	out(0xf2);
	
	
	
	// }EXzC[L
	for (i = 0;;) {
		/*
		 * ܂}EX֐MM
		 */
/*		if (i == 0 && send == false) {
			out(0xf3);
			send = true;
		} else if (i == 1 && send == false) {
			out(200);
			send = true;
		} else if (i == 2 && send == false) {
			out(0xf3);
			send = true;
		} else if (i == 3 && send == false) {
			out(100);
			send = true;
		} else if (i == 4 && send == false) {
			out(0xf3);
			send = true;
		} else if (i == 5 && send == false) {
			out(80);
			send = true;
		} else if (i == 6 && send == false) {
			out(0xf2);
			send = true;
		}
*/		if (g_keycmd->size() > 0 && keycmd_wait < 0) {
			// f[^Aɏ
			Keyboard::wait_sendready();
			//keydat << keycmd_wait;
			keycmd << Mouse::KEYCMD_SENDTO_MOUSE;
			
			keycmd_wait = g_keycmd->back();
			g_keycmd->pop();
			Keyboard::wait_sendready();
			//keydat << keycmd_wait;
			keydat << keycmd_wait;
		}
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = fifo->back();
		fifo->pop();
		io_sti();
		
		if (msg.type == MSG::TYPE::MOUSE) {
		
			if (0 <= i && i <= 6 && msg.arg1 == 0xfa) {
				// G[
				keycmd_wait = -1;
			} else if (msg.arg1 == 0xfe) {
				keydat << keycmd_wait;
				errors++;
			} else if (i == 7 && msg.arg1 == 0) {
				// zC[
				scroll_ = false;
			} else if (i == 7 && msg.arg1 == 3) {
				// zC[L
				scroll_ = true;
			}
			
			if (i == 7 || errors > 10) {
				/*
				 * [v𔲂
				 */
				keycmd_wait = -1;
				break;
			}
			
			if (msg.arg1 != 0xfe) {
				// đvł͖
				i++;
				//send = false;
			}
		}
	}
	
	out(0xe8); // set resolution
	out(0x03); // 8 count/mm
	out(0xe6); // set scaling 1:1
	out(0xf3); // set sample rate
	out(20);
	
	// }EX
	for (i = 0/*, send = false*/;;) {
		/*
		 * }EX̏
		 */
/*		if (i == 0 && send == false) {
			out(0xe8); // set resolution
			send = true;
		} else if (i == 1 && send == false) {
			out(0x03); // 8 count/mm
			send = true;
		} else if (i == 2 && send == false) {
			out(0xe6); // set scaling 1:1
			send = true;
		} else if (i == 3 && send == false) {
			out(0xf3); // set sample rate
			send = true;
		} else if (i == 4 && send == false) {
			out(20);
			send = true;
		}
*/		if (g_keycmd->size() > 0 && keycmd_wait < 0) {
			// f[^Aɏ
			Keyboard::wait_sendready();
			//keydat << keycmd_wait;
			keycmd << Mouse::KEYCMD_SENDTO_MOUSE;
			
			keycmd_wait = g_keycmd->back();
			g_keycmd->pop();
			Keyboard::wait_sendready();
			//keydat << keycmd_wait;
			keydat << keycmd_wait;
		}
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = fifo->back();
		fifo->pop();
		io_sti();
		
		if (msg.type == MSG::TYPE::MOUSE) {
		
			if (0 <= i && i <= 4 && msg.arg1 == 0xfa) {
				// G[
				keycmd_wait = -1;
			} else if (msg.arg1 == 0xfe) {
				keydat << keycmd_wait;
				errors++;
			}
			if (i == 4 || errors > 10) {
				/*
				 * }EXÎŃ[v𔲂
				 */
				keycmd_wait = -1;
				break;
			}
			
			if (msg.arg1 != 0xfe) {
				// đvł͖
				i++;
			}
		}
	}

	// ȉsƁA}EX̍W񂪓͂悤ɂȂ
	//out(MOUSECMD_ENABLE);
	Keyboard::wait_sendready();
	keycmd << Mouse::KEYCMD_SENDTO_MOUSE;
	Keyboard::wait_sendready();
	keydat << MOUSECMD_ENABLE;
	
	// }EX0xfâ҂iK
	mdec.phase = 0;
}

bool Mouse::decode(byte data) {
	bool finished = false; // ͂Itrue
	if (mdec.phase == 0) {
		if (data == 0xfa) {
			mdec.phase = 1;
		}
	} else if (mdec.phase == 1) {
		if ((data & 0xc8) == 0x08) {
			// 1oCgڂ
			mdec.buf[0] = data;
			mdec.phase++;
		}
	} else if (mdec.phase == 2) {
		mdec.buf[1] = data;
		mdec.phase++;
	} else if (mdec.phase == 3) {
		mdec.buf[2] = data;
		if (scroll_ == true) {
			// }EX̓zC[L
			mdec.phase++;
		} else {
			// }EX̓zC[
			mdec.phase = 1;
			
			// zC[Ȃ̂ŁAȉ̉͂IOK
			finished = true;
		}
		
		// ꂩ}EXf[^̉͂
		// ̉͂́AzC[LAŋʂł
		mdec.button = mdec.buf[0] & 0x07;
		mdec.x = mdec.buf[1];
		mdec.y = mdec.buf[2];
		
		if (mdec.buf[0] & 0x10) {
			// X sign bit == 1
			mdec.x |= 0xffffff00;
		}
		
		if (mdec.buf[0] & 0x20) {
			// Y sign bit == 1
			mdec.y |= 0xffffff00;
		}
		mdec.y = -mdec.y;
	} else if (mdec.phase == 4) {
		mdec.buf[3] = data;
		mdec.phase = 1;
		finished = true;
		
		// mdec.buf[3]́A4rbgLȒlł
		// Ƃ肠͂ɒl܂B
		mdec.scroll = mdec.buf[3] & 0x0f;
		if (mdec.scroll & 0x08) {
			// }CiX̒l
			mdec.scroll |= 0xfffffff0;
		}
	}
	return finished;
}

void Mouse::out(byte data)
{
	//IO8 keycmd(Keyboard::PORT_KEYCMD);
	//IO8 keydat(Keyboard::PORT_KEYDAT);
	//Keyboard::wait_sendready();
	//keycmd << Mouse::KEYCMD_SENDTO_MOUSE;
	//Keyboard::wait_sendready();
	//keydat << data;
//	g_keycmd->push(Keyboard::PORT_KEYCMD);
//	g_keycmd->push(Mouse::KEYCMD_SENDTO_MOUSE);
//	g_keycmd->push(Keyboard::PORT_KEYDAT);
	g_keycmd->push(data);
}


