#include "../../bootpack.h"

void RTC::read(system::DateTime* date) {
	int temp;
	temp = read_cmos(SEC);
	date->second = bcd_conv(temp);
	temp = read_cmos(MIN);
	date->minute = bcd_conv(temp);
	temp = read_cmos(HOUR);
	date->hour = bcd_conv(temp);
	temp = read_cmos(DAY);
	date->day = bcd_conv(temp);
	temp = read_cmos(MON);
	date->month = bcd_conv(temp);
	temp = read_cmos(Y_L);
	date->year = bcd_conv(temp);
	temp = read_cmos(Y_H);
	date->year += bcd_conv(temp) * 100;
}


byte driver::read_cmos(byte addr) {
	IO8 rtc_o(0x70);
	IO8 rtc_i(0x71);
	unsigned char data;
	rtc_o << addr;
	rtc_i >> data;
	return data;
}
