#ifndef RTC_H_
#define RTC_H_

namespace system {
	struct DateTime;
}

namespace driver {
	/*
	 * RTCNX
	 */
	class RTC {
	public:
		static const int SEC  = 0x00;
		static const int MIN  = 0x02;
		static const int HOUR = 0x04;
		static const int DAY  = 0x07;
		static const int MON  = 0x08;
		static const int Y_L  = 0x09;
		static const int Y_H  = 0x32;
	public:
		static void read(system::DateTime* date);
	};
	
	byte read_cmos(byte addr);
	
	inline int bcd_conv(int data) {
		return (data >> 4) * 10 + (data & 0x0f);
	}
}

#endif /*RTC_H_*/
