#include "../bootpack.h"

namespace systemtask {
	int cnt_timeout = 0;
	volatile int load_count = 0; // ׌vp
	Sheet* active_sheet = NULL;
	volatile int init_phase = 0; // ̒iK
	
	void key_send(int to, int arg1);
}

using namespace systemtask;


void system::task_idle() {
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	Timer* tim = g_timerctl->alloc();
	tim->set_task(task, 1);
	timer_settime(tim, 1);
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			//g_taskctl->sleep(task);
			// sleepȂŁA10msecSďB
			io_stihlt();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::TIMER) {
			load_count++;
			timer_settime(tim, 1);
		}
		fifo->pop();
	}
}

void system::task_keyboard() {
	Task* task = g_taskctl->get_current_task();
	BootInfo binfo(reinterpret_cast<BootInfo*>(ADR_BOOTINFO));
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	byte data[5] = {0, 0, 0, 0, 0};
	Picture* buffer_back = g_sheet_back->get_buffer();
	char s[256];
	int x, y;
	//queue<int> keycmd(32); // L[{[hɃf[^𑗂邽߂fifo
	Timer* tim = g_timerctl->alloc();
	tim->set_task(task, 100);
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	
	bool Shift = false;
	//bool NumLock = true;
	bool NumLock = false;
	bool ScrollLock = false;
	bool CapsLock = false;
	int key_leds = (binfo.leds >> 4) & 0x07;
	//int key_leds = 0;
//	if (ScrollLock) { key_leds |= 0x01; }
//	if (NumLock) { key_leds |= 0x02; }
//	if (CapsLock) { key_leds |= 0x04; }
	if (key_leds & 0x01) { ScrollLock = true; }
	if (key_leds & 0x02) { NumLock = true; }
	if (key_leds & 0x04) { CapsLock = true; }
	
	while (init_phase == 0); // }EX̏҂
	
	// HႢh~̂߁Aݒ肵Ă
	Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
	//keycmd.push(Keyboard::KEYCMD_LED);
	//keycmd.push(key_leds);
	
	Keyboard::out(0xf3, 0x00 | 0x00); // L[̃s[gxAx
	
	int keycmd_wait = -1;
	IO8 keydat(Keyboard::PORT_KEYDAT);
	
	for (;;) {
		if (g_keycmd->size() > 0 && keycmd_wait < 0) {
			// f[^Aɏ
			keycmd_wait = g_keycmd->back();
			g_keycmd->pop();
			Keyboard::wait_sendready();
			keydat << keycmd_wait;
		}
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::KEYBOARD) {
			int to = g_shtctl->get_taskid(active_sheet);
			data[4] = data[3];
			data[3] = data[2];
			data[2] = data[1];
			data[1] = data[0];
			data[0] = msg->arg1;
			sprintf(s, "KEY CODE : %02X -> %02X -> %02X -> %02X -> %02X",
				data[0], data[1], data[2], data[3], data[4]);
			buffer_back->box(0, 16, strlen(s) * 8 - 1, 32 - 1, Screen::BACKGROUND_COLOR);
			buffer_back->putstr(0, 16, s, 0xffff);
			g_shtctl->refresh(g_sheet_back, 0, 16, strlen(s) * 8, 32);
			if (data[0] == 0x01) { // ESCL[Ńu[g
//				pic0_imr << 0xff; // S荞݋֎~
//				pic1_imr << 0xff;
				Mouse::out(0xf5); // f[^M֎~
				while (task1_fifo->size() > 0) {
					task1_fifo->pop();
				}
				for (y = 0; y < buffer_back->get_ysize(); y++) {
					for (x = 0; x < buffer_back->get_xsize(); x++) {
						g_screen->point(x, y,
							mixC(
								convC_inv(g_screen->get_color(x, y)), 0xa0a0a0, 50, 50
								)
							);
					}
				}
				*dbg << "rebooting system.";
				dbg->flush();
				cnt_timeout = 0;
				timer_settime(tim, 100);
			} else if (data[0] == 0x46) {
				// ScrollLock
				ScrollLock = !ScrollLock;
				key_leds ^= 0x01;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0x45) {
				// NumLock
				NumLock = !NumLock;
				key_leds ^= 0x02;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0x3a) {
				// CapsLock
				CapsLock = !CapsLock;
				key_leds ^= 0x04;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0xfa) {
				// ACKAĂ
				keycmd_wait = -1;
			} else if (data[0] == 0xfe) {
				// Ɏ󂯎ȂAx
				Keyboard::wait_sendready();
				keydat << keycmd_wait;
			} else if (data[1] == 0xe0) {
				// gL[R[h
				if (data[0] == 0x48) {
					key_send(to, MSG::KEY::ARROW_UP);
				} else if (data[0] == 0x50) {
					key_send(to, MSG::KEY::ARROW_DOWN);
				} else if (data[0] == 0x4d) {
					key_send(to, MSG::KEY::ARROW_RIGHT);
				} else if (data[0] == 0x4b) {
					key_send(to, MSG::KEY::ARROW_LEFT);
				} else if (data[0] == 0x49) {
					key_send(to, MSG::KEY::PAGE_UP);
				} else if (data[0] == 0x51) {
					key_send(to, MSG::KEY::PAGE_DOWN);
				}
			} else if (data[0] == 0x0f) {
				// TABL[
				*dbg << "tab";
				g_taskctl->send_message(TASK_MOUSE,
					Message::create(MSG::TYPE::SYSTEM, MSG::SYSTEM::WINDOW_CHANGE)
				);
			} else if (data[0] == 0x2a || data[0] == 0x36) {
				// Eshift
				Shift = true;
			} else if (data[0] == 0x2a + 0x80 || data[0] == 0x36 + 0x80) {
				Shift = false;
			} else if (data[0] == 0x1d) {
				// Ctrl
//			} else if (data[0] == 0x38) {
//				// Alt
			} else {
				if (data[0] < 0x80) {
					char c;
					if (Shift) {
						c = keytable1[data[0]];
					} else {
						c = keytable0[data[0]];
					}
					if (((!Shift && !CapsLock) || (Shift && CapsLock)) &&
						('A' <= c && c <= 'Z')) {
						c += 0x20;
					}
//					if (to != -1) {
//						g_taskctl->send_message(to,
//							Message::create(MSG::TYPE::KEYBOARD, c)
//						);
//					}
					if (c != 0) {
						key_send(to, c);
					}
				}
			}
		} else if (msg->type == MSG::TYPE::TIMER) {
			if (msg->arg1 == 100) {
				if (cnt_timeout < 2) {
					sprintf(s, "%d", 2 - cnt_timeout);
					cnt_timeout++;
					timer_settime(tim, 100);
					*dbg << s;
					dbg->flush();
				} else {
					io_cli();
					IO8 KBC(0x64);
					KBC << 0xfe; // reboot
					for (;;) { io_hlt(); }
				}
			}
		}
		fifo->pop();
	}
}

void system::task_mouse() {
	Picture* buffer_back = g_sheet_back->get_buffer();
	// }EXJ[\̈ʒuLpϐ
	int m_xpos = buffer_back->get_xsize() / 2;
	int m_ypos = buffer_back->get_ysize() / 2;
	int m_xpos_old, m_ypos_old;
	int dm_xpos, dm_ypos; // J[\ړω
	
	bool right_pushed = false;
	bool left_pushed = false;
	bool middle_pushed = false;
	
	int button, scroll;
	
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	
	Mouse::enable(task);
	
	init_phase = 1; // }EXI̍}
	
	// }EXJ[\pV[g̐
	Sheet* sheet_mouse = g_shtctl->alloc(TASK_MOUSE, true);
	sheet_mouse->init(Mouse::XSIZE, Mouse::YSIZE);
	Picture* buffer_mouse = sheet_mouse->get_buffer();
	sheet_mouse->set_invisible_color(0x0001);
	Mouse::init_cursor(buffer_mouse);
	g_shtctl->slide(sheet_mouse, m_xpos, m_ypos);
	g_shtctl->updown(sheet_mouse, 1000);
	
	// EBhEhbOԂǂ
	bool window_drag = false;
	
	Sheet* on_sheet = 0;
	/*Sheet* */active_sheet = get_sheet_taskid(TASK_KERNEL);
	Picture* buf_on_sheet = 0;
	Sheet* sheet_win1 = active_sheet;
	int xpos_on_sheet = 0, ypos_on_sheet = 0;
	Picture* buffer_win1 = sheet_win1->get_buffer();
	
	Sheet* sheet_taskbar = get_sheet_taskid(TASK_TASKBAR);
	Picture* buffer_taskbar = sheet_taskbar->get_buffer();
	Sheet* sheet_dframe = NULL;
	
	
	char s[256];
	
	*dbg << "mouse";

	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::MOUSE) {
			if (Mouse::decode(msg->arg1)) {
				// fR[h
				m_xpos_old = m_xpos;
				m_ypos_old = m_ypos;
				m_xpos += Mouse::mdec.x;
				m_ypos += Mouse::mdec.y;
				if (m_xpos < 0) { m_xpos = 0; }
				if (m_xpos >= buffer_back->get_xsize()) { m_xpos = buffer_back->get_xsize() - 1; }
				if (m_ypos < 0) { m_ypos = 0; }
				if (m_ypos >= buffer_back->get_ysize()) { m_ypos = buffer_back->get_ysize() - 1; }
				dm_xpos = m_xpos - m_xpos_old;
				dm_ypos = m_ypos - m_ypos_old;
				g_shtctl->slide(sheet_mouse, m_xpos, m_ypos);
				
				button = Mouse::mdec.button;
				scroll = Mouse::mdec.scroll;
				
				if (right_pushed != false && Mouse::mdec.button & 0x02) {
					right_pushed = true;
					
				}
				if (button & 0x04) { middle_pushed = true; }
				
				if (!window_drag) {
					int sid = g_shtctl->get_sheetid(m_xpos, m_ypos);
					on_sheet = g_shtctl->get_sheet(sid);
					buffer_win1->box(10, 55, 10 + 8 * 10 - 1, 55 + 32 - 1, Screen::TASKBAR_COLOR);
					sprintf(s, "%04d, %04d", dm_xpos, dm_ypos);
					buffer_win1->putstr(10, 55, s, convC(0x555555));
					sprintf(s, "scroll %2d", scroll);
					buffer_win1->putstr(10, 55 + 16, s, convC(0x555555));
					g_shtctl->refresh(sheet_win1, 10, 55, 10 + 8 * 10, 55 + 32);
					
					buffer_win1->box(10, 55 + 16 * 3, 10 + 8 * 9 - 1, 55 + 16 * 4 - 1, Screen::TASKBAR_COLOR);
					sprintf(s, "sid = %03d", sid);
					buffer_win1->putstr(10, 55 + 16 * 3, s, 0x0000);
					g_shtctl->refresh(sheet_win1, 10, 55 + 16 * 3, 10 + 8 * 9, 55 + 16 * 4);
				} else {
					#if DRAG_FRAME == 1
					g_shtctl->slide(sheet_dframe,
						sheet_dframe->get_xpos() + dm_xpos,
						sheet_dframe->get_ypos() + dm_ypos);
					#elif DRAG_FRAME == 2
					g_shtctl->slide_dragframe(sheet_dframe,
						sheet_dframe->get_xpos() + dm_xpos,
						sheet_dframe->get_ypos() + dm_ypos);
					#endif
				}
/*
				sprintf(s, "lcr scroll=%d", scroll);
				if (button & 0x01) { s[0] = 'L'; }
				if (button & 0x02) { s[2] = 'R'; }
				if (button & 0x04) { s[1] = 'C'; }
				buffer_back->box(0, 32, strlen(s) * 8 + 7, 48 - 1, Screen::BACKGROUND_COLOR);
				buffer_back->putstr(0, 32, s, 0xffff);
				g_shtctl->refresh(sheet_back, 0, 32, strlen(s) * 8 + 8, 48);
				
				if (scroll != 0 && (button & 0x04) == 0) {
					g_shtctl->slide(sheet_win1,
						sheet_win1->get_xpos(), sheet_win1->get_ypos() + 16 * 3 * scroll);
				} else if (scroll != 0 && (button & 0x04) != 0) {
					g_shtctl->slide(sheet_win1,
						sheet_win1->get_xpos() + 16 * 3 * scroll, sheet_win1->get_ypos());
				}
*/

				if (left_pushed == false && button & 0x01) {
					// left push
					left_pushed = true;
					buf_on_sheet = on_sheet->get_buffer();
					xpos_on_sheet = on_sheet->get_xpos();
					ypos_on_sheet = on_sheet->get_ypos();
					if (xpos_on_sheet <= m_xpos &&
						m_xpos <= xpos_on_sheet + buf_on_sheet->get_xsize() &&
						ypos_on_sheet <= m_ypos &&
						m_ypos <= ypos_on_sheet + buf_on_sheet->get_ysize())
					{
						if (!on_sheet->fixed()) {
							g_shtctl->updown(on_sheet, 1000);
							// active_sheetinactiveɁAon_sheetactiveɐ؂ւ
							swap_active(active_sheet, on_sheet);
							active_sheet = on_sheet;
						}
						if (m_ypos <= ypos_on_sheet + 28 && !on_sheet->fixed())
						{
							// EBhẼ^Cgo[ŃNbN
							window_drag = true;
							sheet_dframe = g_shtctl->alloc();
							#if DRAG_FRAME == 1
							sheet_dframe->init(20, 20);
							#elif DRAG_FRAME == 2
							sheet_dframe->init(
								on_sheet->get_buffer()->get_xsize(), on_sheet->get_buffer()->get_ysize());
							sheet_dframe->set_invisible_color(0x0000);
							#endif
							Picture* buffer_dframe = sheet_dframe->get_buffer();
							
							#if DRAG_FRAME == 1
							buffer_dframe->box(0, 0,
								20 - 1, 20 - 1,
								0x0000);
							buffer_dframe->box(8, 0,
								12 - 1, 20 - 1,
								convC(0xC0C0C0));
							buffer_dframe->box(0, 8,
								20 - 1, 12 - 1,
								convC(0xC0C0C0));
							g_shtctl->slide(sheet_dframe,
								on_sheet->get_xpos() - 10, on_sheet->get_ypos() - 10);
							#elif DRAG_FRAME == 2
							buffer_dframe->box(0, 0,
								buffer_dframe->get_xsize() - 1, buffer_dframe->get_ysize() - 1,
								convC(0xC0C0C0));
							buffer_dframe->box(2, 2,
								buffer_dframe->get_xsize() - 3, buffer_dframe->get_ysize() - 3,
								0x0000);
							g_shtctl->slide_dragframe(sheet_dframe,
								on_sheet->get_xpos(), on_sheet->get_ypos());
							#endif
							g_shtctl->updown(sheet_dframe, 1000);
						} else {
							// ^Cgo[ȊOiEBhEjŃNbN
							int to = g_shtctl->get_taskid(on_sheet);
							sprintf(s, "test %d %d", to, on_sheet->get_height());
							*dbg << s;
							g_taskctl->send_message(to,
								Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::COORDINATE, m_xpos, m_ypos)
							);
						}
					}
				} else if (left_pushed && (button & 0x01) == 0) {
					// left release
					left_pushed = false;
					if (window_drag) {
						g_shtctl->updown(sheet_dframe, -1);
//						g_shtctl->updown(sdf_t, -1);
//						g_shtctl->updown(sdf_b, -1);
//						g_shtctl->updown(sdf_l, -1);
//						g_shtctl->updown(sdf_r, -1);
						#if DRAG_FRAME == 1
						g_shtctl->slide(on_sheet,
							sheet_dframe->get_xpos() + 10, sheet_dframe->get_ypos() + 10);
						#elif DRAG_FRAME == 2
						g_shtctl->slide(on_sheet,
							sheet_dframe->get_xpos(), sheet_dframe->get_ypos());
						#endif
						g_shtctl->free(sheet_dframe);
						window_drag = false;
					}
				} else {
					int to = g_shtctl->get_taskid(on_sheet);
					if (scroll != 0) {
						// XN[𑗂
						g_taskctl->send_message(to,
							Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::SCROLL, scroll)
						);
					} else if (button != 0) {
						// W𑗂
						g_taskctl->send_message(to,
							Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::COORDINATE, m_xpos, m_ypos, button)
						);
					}
				}
			}
		} else if (msg->type == MSG::TYPE::SYSTEM) {
			if (msg->arg1 == MSG::SYSTEM::WINDOW_CHANGE) {
				Sheet* old_high = g_shtctl->get_sheet_2();
				Sheet* new_high;
				if (!old_high->fixed() && !window_drag) {
					//g_shtctl->updown(old_high, 3);
					//new_high = g_shtctl->get_sheet_2();
					new_high = g_shtctl->get_sheet(g_shtctl->get_sheetid(3));
					g_shtctl->updown(new_high, 1000);
					// active_sheetinactiveɁAon_sheetactiveɐ؂ւ
					swap_active(old_high, new_high);
					active_sheet = new_high;
				}
			}
		}
		fifo->pop();
	}
}

void system::task_taskbar() {
	Picture* buffer_back = g_sheet_back->get_buffer();
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	
	DateTime date1, date2;
	char s[256];

	Sheet* taskbar = get_sheet_taskid(g_taskctl->get_taskid(task));
	Picture* buffer = taskbar->get_buffer();
	
	box_sht(taskbar, 1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x203050));
	putstr_sht(taskbar, 10 + 4, 5, "", 0xffff, convC(0x203050));
	
	Timer* tim1 = g_timerctl->alloc();
	tim1->set_task(task, 1);
	timer_settime(tim1, 5);
	Timer* tim2 = g_timerctl->alloc();
	tim2->set_task(task, 2);
	timer_settime(tim2, 3);
	
	bool menu_open = false;
	Sheet* m1 = NULL;
	Picture* b1 = NULL;
	
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::TIMER) {
			if (msg->arg1 == 1) {
				timer_settime(tim1, 100);
				buffer->box(buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 3, 17, Screen::TASKBAR_COLOR);
				sprintf(s, "%02d/%02d  %02d:%02d",
					date1.month, date1.day, date1.hour, date1.minute, date1.second);
				buffer->putstr(buffer->get_xsize() - 6 * 12 - 2, 6, s, 0x0000, font_mini);
				g_shtctl->refresh(taskbar, buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 2, 18);
				date1.second++;
				if (date1.second >= 60) {
					date1.second = 0;
					date1.minute++;
				}
				if (date1.minute >= 60) {
					date1.minute = 0;
					date1.hour++;
				}
				if (date1.hour >= 24) {
					date1.hour = 0;
					date1.day++;
				}
				if ((date1.day > 31 &&
					(date1.month == 1 || date1.month == 3 || date1.month == 5 ||
					date1.month == 7 || date1.month == 8 || date1.month == 10 ||
					date1.month == 12)) ||
					(date1.day > 30 &&
					(date1.month == 4 || date1.month == 6 || date1.month == 9 ||
					date1.month == 11)) ||
					(date1.day > 28 && date1.month == 2))
				{
					date1.day = 0;
					date1.month++;
				}
				if (date1.month > 12) {
					date1.month = 0;
					date1.year++;
				}
			} else if (msg->arg1 == 2) {
				timer_settime(tim2, 6000);
				RTC::read(&date1);
				RTC::read(&date2);
				int i = 0;
				while (date1 != date2 ||
					(date1.second < 0 || date1.second > 60) ||
					(date1.minute < 0 || date1.minute > 59) ||
					(date1.hour < 0 || date1.hour > 24) ||
					(date1.day < 1 || date1.day > 31) ||
					(date1.month < 1 || date1.month > 12) ||
					(date1.year < 1990))
				{
					RTC::read(&date1);
					RTC::read(&date2);
					if (i > 5) { break; }
					i++;
				}
			}
		} else if (msg->type == MSG::TYPE::MOUSE && msg->arg1 == MSG::MOUSE::COORDINATE) {
			int xpos = msg->arg2;
			int ypos = msg->arg3;
			sprintf(s, "clicked %04d, %03d", xpos, ypos);
			buffer->box(200, 7, 200 + 8 * 17 - 1, 22, Screen::TASKBAR_COLOR);
			buffer->putstr(200, 7, s, 0x0000);
			g_shtctl->refresh(taskbar, 200, 7, 200 + 8 * 17, 23);
			if (10 <= xpos && xpos < 20 + 8 * 5 && !menu_open) {
				menu_open = true;
				if (m1 == NULL) {
					m1 = g_shtctl->alloc(TASK_TASKBAR);
					m1->init(200, 400);
					m1->set_fix(true);
					b1 = m1->get_buffer();
					b1->box(0, 0, 199, 399, convC(0x556677));
					b1->putstr(10, 10, "start menu", 0xffff);
					g_shtctl->slide(m1, 0, taskbar->get_ypos() - 400);
				}
				g_shtctl->updown(m1, 1000);
			} else if (menu_open) {
				g_shtctl->updown(m1, -1);
				menu_open = false;
			}
		}
		fifo->pop();
	}
}

void system::task_b_main() {
	Task* current_task = g_taskctl->get_current_task();
	Sheet* sht = g_shtctl->alloc(g_taskctl->get_taskid(current_task));
	sht->init(300, 200);
	sht->set_invisible_color(0x0001);
	Window::make(sht, false);
	Picture* buf = sht->get_buffer();
	buf->box(3,  29, 300 - 4, 200 - 4, Screen::TASKBAR_COLOR);
	buf->putstr(10, 8, "load", 0xffff);
	buf->putstr(11, 8, "load", 0xffff);
	g_shtctl->updown(sht, 4);
	g_shtctl->slide(sht, 200, 20);
	
	queue<Message>* fifo = current_task->fifo();
	Message msg;
	char s[256], tmp[256];
	Timer* tim = g_timerctl->alloc();
	tim->set_task(g_taskctl->get_current_task(), 1);
	timer_settime(tim, 50);
	int count = 0, count_10sec = 0, count_loop = 19;
	int percent = 0;
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(current_task);
			io_sti();
			continue;
		}
		msg = fifo->back();
		fifo->pop();
		io_sti();
		if (msg.type == MSG::TYPE::TIMER) {
			if (msg.arg1 == 1) {
				timer_settime(tim, 50);
//				buf->box(20, 50 + 16 * 1, 20 + 8 * 18 - 1, 50 + 16 * 4 - 1, Screen::TASKBAR_COLOR);
//				buf->putstr(20, 50 + 12 * 1, "ѱ ޶", 0x0000, font_mini);
				count = load_count;
				putstr_sht(sht, 20, 50 + 13 * 1, "ѱ ޶", 0x0000, Screen::TASKBAR_COLOR, font_mini);
				if (count >= 50) { count = 50; }
				if (count < 0) { count = 0; }
				percent = (50 - count) * 2;
				sprintf(s, "%3u0 msec/sec", count * 2);
				putstr_sht(sht, 20, 50 + 13 * 2, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
//				buf->putstr(20, 50 + 16 * 2, s, 0x0000);
				sprintf(s, "0.5sec CPU̶ %2u %%", percent);
				putstr_sht(sht, 20, 50 + 13 * 3, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
//				buf->putstr(20, 50 + 16 * 3, s, 0x0000);
//				g_shtctl->refresh(sht, 20, 50 + 16 * 1, 20 + 8 * 18, 50 + 16 * 4);
				load_count = 0;
				count_10sec += count;
				count_loop++;
				if (count_loop >= 20) {
					count_loop = 0;
					percent = (1000 - count_10sec) / 10;
					sprintf(s, "10 sec CPU̶ %2u %%", percent);
					putstr_sht(sht, 20, 50 + 13 * 4, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
					count_10sec = 0;
				}
				sprintf(s, "Power On %5d sec", g_timerctl->get_count() / 100);
				putstr_sht(sht, 20, 50 + 13 * 5, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
			}
		}
	}
}



void systemtask::key_send(int to, int arg1) {
	if (to >= 0) {
		g_taskctl->send_message(to,
			Message::create(MSG::TYPE::KEYBOARD, arg1)
		);
	}
}

