#include "../bootpack.h"

void system::task_console() {
	const int xsize = 8 * 40;
	const int ysize = 16 * 12;
	const int CMDLINE_MAX = 256;
	const int CMDHIS_MAX = 16;
	
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message msg;
	char s[256];
	char cmdline[CMDLINE_MAX];
	char *cmdlinebuf = new char[CMDLINE_MAX * CMDHIS_MAX];
	int cmdhis = 0; // R}hC̃CfbNX
	int cmdhis_old = 0; // R}hC̃CfbNX
	int cmdhis_input = 0; // R}hC͍̓s
	bool show_history = false;
	int c;
	
	Sheet* sht_cons = g_shtctl->alloc(g_taskctl->get_taskid(task));
	sht_cons->init(xsize + 8 * 2 - 1, ysize + 30 + 5 + 8  + 16 * 1);
	sht_cons->set_invisible_color(Screen::BACKGROUND_COLOR);
	Picture* buf_cons = sht_cons->get_buffer();
	buf_cons->box(3, 32, buf_cons->get_xsize() - 4, buf_cons->get_ysize() - 4, Screen::TASKBAR_COLOR);
	Textbox::make(sht_cons, 8, 37 + 16 * 1, xsize, ysize, 0x0000);
	Window::make(sht_cons, false);
	buf_cons->putstr(10, 8, "console", 0xffff);
	buf_cons->putstr(11, 8, "console", 0xffff);
	g_shtctl->slide(sht_cons, 250, 200);
	g_shtctl->updown(sht_cons, 1000);
	
	Timer* cursor_tim = g_timerctl->alloc();
	cursor_tim->set_task(task, 1);
	timer_settime(cursor_tim, 70);
	
	Console cons(sht_cons, xsize, ysize, 8, 37 + 16 * 1);
	
	bool scroll_mode = false;
	int scrolly = 0, scroll = 0;
	int cmdline_len = 0; // R}h̕
	bool cursor_on = false; // J[\_ł邩
	bool cursor = false; // J[\̕\ԁi݌Ă邩Ă邩j
	
	cons.putchar('>');
	cons.cursor(false);
	
	for (int i = 0; i < CMDHIS_MAX; i++) {
		cmdlinebuf[CMDLINE_MAX * i] = '\0';
	}
	
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = fifo->back(); // ͎̓nɒ
		fifo->pop();
		io_sti();
		if (msg.type == MSG::TYPE::KEYBOARD) {
			c = msg.arg1;
			if (scroll_mode && c < 0x100) {
				scroll_mode = false;
				cons.cursor_on();
				cons.scroll(-scrolly);
				scrolly = 0;
			}
			//buf_cons->putstr(8, 37, s, 0xffff);
			if (c == '\n') {
				cons.putchar('\n');
				cmdline[cmdline_len] = '\0';
				cmdline_len = 0;
				strcpy(cmdlinebuf + cmdhis_input * CMDLINE_MAX, cmdline);
				cmdhis_input++;
				cmdhis_old = cmdhis = cmdhis_input;
				if (cmdhis_input >= CMDHIS_MAX) {
					cmdhis_input = 0;
				}
				cons_runcmd(&cons, cmdline);
				cons.putchar('>');
				cons.flush();
				
				// R}hC̃eXg\
				buf_cons->box(4, 34, 4 + xsize + 5, 45, Screen::TASKBAR_COLOR);
				cmdline[xsize / 6] = 0;
				buf_cons->putstr(4, 33, cmdline, 0x0000, font_mini);
				g_shtctl->refresh(sht_cons, 4, 34, 4 + xsize + 6, 46);
			} else if (c == '\b') {
				if (cmdline_len > 0) {
					cons.putchar('\b');
					cmdline_len--;
				}
			} else if (c < 0x100) {
				cmdline[cmdline_len++] = c;
				cons.putchar(c);
			} else if (c == MSG::KEY::ARROW_UP) {
				if ((cmdhis == cmdhis_input && cmdhis_old == cmdhis) ||
					(cmdhis < cmdhis_input || cmdhis_input < cmdhis)) {
					cmdhis_old = cmdhis;
					if (0 < cmdhis) {
						cmdhis--;
					} else {
						cmdhis = CMDHIS_MAX - 1;
					}
				}
				show_history = true;
			} else if (c == MSG::KEY::ARROW_DOWN) {
				if (cmdhis_input == 0) {
					if (cmdhis + 1 < CMDHIS_MAX) {
						cmdhis++;
					}
				} else if ((cmdhis + 1 < cmdhis_input) || (cmdhis_input <= cmdhis)) {
					if (cmdhis < CMDHIS_MAX - 1) {
						cmdhis++;
					} else {
						cmdhis = 0;
					}
				}
				show_history = true;
			} else if (c == MSG::KEY::PAGE_UP) {
				scroll = -ysize / 16 + 2;
			} else if (c == MSG::KEY::PAGE_DOWN) {
				scroll = ysize / 16 - 2;
			}
			if (show_history) {
				cons.clear_line();
				strcpy(cmdline, cmdlinebuf + CMDLINE_MAX * cmdhis);
				cmdline_len = strlen(cmdline);
				cons.putstr(cmdline);
				show_history = false;
			}
			//g_shtctl->refresh(sht_cons, 8, 37, 8 + 8 * 2, 37 + 16);
			//cons.flush();
		} else if (msg.type == MSG::TYPE::MOUSE) {
			if (msg.arg1 == MSG::MOUSE::SCROLL) {
				scroll = msg.arg2 * 3;
			}
		} else if (msg.type == MSG::TYPE::SYSTEM) {
			if (msg.arg1 == MSG::SYSTEM::WINDOW_ACTIVE) {
				cursor_on = true;
				cons.cursor_on();
			} else if (msg.arg1 == MSG::SYSTEM::WINDOW_INACTIVE) {
				cursor_on = false;
				cons.cursor(false);
				cons.cursor_off();
			}
		} else if (msg.type == MSG::TYPE::TIMER) {
			if (msg.arg1 == 1) {
				// J[\p^C}[̃^CAbv
				timer_settime(cursor_tim, 70);
				if (cursor_on && !scroll_mode) {
					cursor = !cursor;
					cons.cursor(cursor);
				}
			}
		}
		if (scroll != 0) {
			scroll_mode = true;
			cons.cursor_off();
			if ((scroll < 0 && -cons.get_bufysize() - scroll + ysize / 16 < scrolly) ||
				(scroll > 0 && scrolly < cons.get_bufysize() - scroll - ysize / 16)) {
				scrolly += scroll;
				cons.scroll(scroll);
			}
			scroll = 0;
		}
	}
	delete[] cmdlinebuf;
	for (;;);
}

Console::Console(Sheet* sht, int xsize, int ysize,
	int offsetx, int offsety, color_16 color, color_16 bgcolor)
	: str_(0),
	xsize_(xsize), ysize_(ysize), xofs_(offsetx), yofs_(offsety),
	curx_(offsetx), cury_(offsety), bufx_(0), bufy_(0), showy_(0),
	color_(color), bgcolor_(bgcolor),
	xmove_(0), ymove_(0), font_(0),
	sht_(sht), buf_(sht->get_buffer()),
	cursor_on_(false)
{
	set_font(font_gothic);
	bufxsize_ = xsize_ / xmove_;
	// Ƃ肠10ʕ̃obt@m
	bufysize_ = 10 * (ysize_ / ymove_);
	str_ = new char[(xsize / xmove_ + 1) * bufysize_];
	cury_max_ = ysize_ - (ymove_ - yofs_);
}

Console::~Console() {
	delete[] str_;
}

void Console::set_font(Font* font) {
	font_ = font;
	xmove_ = font->getxsize();
	ymove_ = font->getysize();
}

void Console::putstr(const char* str, bool refresh) {
	//int length = strlen(str);
	int curx0 = curx_;
	int cury0 = cury_;
	//for (int i = 0; i < length && *str != '\0'; i++) {
	while (*str != '\0') {
		putchar(*str, false);
		str++;
	}
	if (refresh) {
		if (cury_ >= cury0) {
			// sĂ
			g_shtctl->refresh(sht_, xofs_, cury0, xofs_ + xsize_, cury_ + ymove_);
		} else {
			g_shtctl->refresh(sht_, curx0, cury0, curx_, cury_ + ymove_);
		}
	}
}

void Console::putchar(char c, bool refresh) {
	cursor(false);
	if (c == '\n') {
		newline(refresh);
	} else if (c == '\b') {
		if (bufx_ == 0) {
			curx_ = xofs_ + xsize_;
			cury_ -= ymove_;
			bufx_ = bufxsize_;
			bufy_--;
			if (bufy_ < 0) { bufy_ = bufysize_ - 1; }
			if (cury_ < yofs_) { cury_ = yofs_; }
		}
		curx_ -= xmove_;
		bufx_--;
		buf_->box(curx_, cury_, curx_ + xmove_ - 1, cury_ + ymove_ - 1, bgcolor_);
		if (refresh) {
			g_shtctl->refresh(sht_, curx_, cury_, curx_ + xmove_, cury_ + ymove_);
		}
	} else {
		str_[bufy_ * (bufxsize_ + 1) + bufx_] = c;
		bufx_++;
		buf_->putchar(curx_, cury_, c, color_, font_);
		if (refresh) {
			g_shtctl->refresh(sht_, curx_, cury_, curx_ + xmove_, cury_ + ymove_);
		}
		//curx_ += xmove_;
		if (curx_ >= xsize_) {
			newline(refresh);
		} else {
			curx_ += xmove_;
		}
	}
	cursor(true);
}

void Console::flush() {
	int x, y/*, i = showy_*/;
	int curx, cury = yofs_;
	int showy = showy_;
	//char* showy = str_ + showy_ * (bufxsize_ + 1);
	char c;
	buf_->box(xofs_, yofs_, xofs_ + xsize_ - 1, yofs_ + ysize_ - 1, bgcolor_);
	for (y = 0; y < ysize_ / ymove_; y++) {
		curx = xofs_;
/*		for (x = 0; x < bufxsize_; x++) {
			c = str_[showy * (bufxsize_ + 1) + x];
			if (c == '\0') { break; }
			buf_->putchar(curx, cury, c, color_, font_);
			curx += xmove_;
		}
*/
		buf_->putstr(curx, cury, str_ + showy * (bufxsize_ + 1), color_, font_);
		//buf_->putstr(curx, cury, showy, color_, font_);
		cury += ymove_;
		//showy += bufxsize_ + 1;
		//i++;
		showy++;
		if (showy >= bufysize_) {
			showy = 0;
			//showy = str_;
		}
	}
	g_shtctl->refresh(sht_, xofs_, yofs_, xofs_ + xsize_, yofs_ + ysize_);
}

void Console::scroll(int line, bool refresh) {
	// ʂXN[
	showy_ += line;
	if (showy_ < 0) {
		showy_ += bufysize_;
	} else if (showy_ >= bufysize_) {
		showy_ -= bufysize_;
	}
	if (refresh) {
		flush();
	}
}

void Console::newline(bool refresh) {
	str_[bufy_ * (bufxsize_ + 1) + bufx_] = '\0';
//	if (cury_ + ymove_ - yofs_ >= ysize_) {
	bufy_++;
	if (bufy_ >= bufysize_) {
		bufy_ = 0;
	}
	if (cury_ >= cury_max_) {
		char* p = str_ + bufy_ * (bufxsize_ + 1);
		//str_[bufy_ * (bufxsize_ + 1)] = '\0';
		for (bufx_ = 0; bufx_ < /*bufxsize_*/2; bufx_++) {
			//str_[bufy_ * (bufxsize_ + 1) + bufx_] = '\0';
			*p++ = '\0';
		}

		//*p = '\0';
		scroll(1, refresh);
	} else {
		cury_ += ymove_;
	}
	curx_ = xofs_;
	bufx_ = 0;
//	bufx_ = 0;
//	buf_->box(curx_, cury_, curx_ + xsize_ - 1, cury_ + ymove_ - 1, bgcolor_);
//	g_shtctl->refresh(sht_, curx_, cury_, curx_ + xsize_, cury_ + ymove_);
}

void Console::cursor(bool on) {
	if (cursor_on_) {
		if (on) {
			buf_->box(curx_, cury_, curx_ + xmove_ - 1, cury_ + ymove_ - 1, color_);
		} else {
			buf_->box(curx_, cury_, curx_ + xmove_ - 1, cury_ + ymove_ - 1, bgcolor_);
		}
		g_shtctl->refresh(sht_, curx_, cury_, curx_ + xmove_, cury_ + ymove_);
	}
}

void Console::clear() {
	int x, y;
	for (y = 0; y < bufysize_; y++) {
		for (x = 0; x < bufxsize_ + 1; x++) {
			str_[y * (bufxsize_ + 1) + x] = '\0';
		}
	}
	bufx_ = 0;
	bufy_ = 0;
	curx_ = xofs_;
	cury_ = yofs_;
	showy_ = 0;
	flush();
}

void Console::clear_line() {
	curx_ = xofs_ + xmove_;
	bufx_ = 1;
	str_[bufy_ * (bufxsize_ + 1) + 1] = '\0';
	buf_->box(curx_, cury_, xofs_ + xsize_ - 1, cury_ + ymove_ - 1, bgcolor_);
}



/*
 * R}hs֐
 */
void system::cons_runcmd(Console* cons, const char* cmdline) {
	if (strcmp(cmdline, "mem") == 0) {
		cmd_mem(cons);
	} else if (strcmp(cmdline, "cls") == 0) {
		cmd_cls(cons);
	} else if (strcmp(cmdline, "dir") == 0) {
		cmd_dir(cons);
	} else if (strncmp(cmdline, "type ", 5) == 0) {
		cmd_type(cons, cmdline);
	} else {
		cons->putstr("Bad command.\n\n");
	}
}

void system::cmd_mem(Console* cons) {
	// cʕ\R}h
	char s[64];
	sprintf(s, "total  %dMB\nfree   %dKB\n\n", memory_size / 1024 / 1024, g_km.getFreeSize() / 1024);
	cons->putstr(s);
}

void system::cmd_cls(Console* cons) {
	cons->clear();
}

void system::cmd_dir(Console* cons) {
	FileInfo* finfo = (FileInfo*) (ADR_DISKIMG + 0x002600);
	char s[64];
	for (int i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00) {
			// t@C͂ȍ~ɂ͖
			break;
		}
		if (finfo[i].name[0] != 0xe5) {
			sprintf(s, "filename.ext  %7d\n", finfo[i].size);
			memcpy(s, finfo[i].name, 8);
			memcpy(s + 9, finfo[i].ext, 3);
			cons->putstr(s);
		}
	}
	cons->putchar('\n');
}

void system::cmd_type(Console* cons, const char* cmdline) {
	char s[32];
	int time1 = g_timerctl->get_count();
	FileEntry* entry = FAT12::load(cmdline + 5);
	if (entry != NULL) {
		// t@C
		cons->cursor_off();
		byte* p = entry->get_buffer();
		int size = entry->get_size();
		int i = 0;
		for (; 0 < size; size--) {
			if (*p != '\r') {
				cons->putchar(*p, false);
			}
			if (*p == '\n') {
				i++;
				if ((i % 4) == 0) {
					cons->flush();
				}
			}
			p++;
		}
		cons->cursor_on();
	} else {
		cons->putstr(cmdline + 5);
		cons->putstr(" not found.\n");
	}
	int time2 = g_timerctl->get_count();
	sprintf(s, "time %d.%dsec\n", (time2 - time1) / 100, (time2 - time1) % 100);
	cons->putstr(s);
	cons->putchar('\n');
	delete entry;
}

