#include "../bootpack.h"

DebugWindow::DebugWindow(int xpos, int ypos, int xsize, int ysize)
{
	cursor_y_ = 3;
	xpos_ = xpos;
	ypos_ = ypos;
	xsize_ = xsize;
	ysize_ = ysize;
	sht_win_ = g_shtctl->alloc();
	sht_win_->init(xsize_, ysize_);
	sht_win_->set_fix(true);
	sht_win_->set_invisible_color(BACK_COLOR);
	sht_win_->get_buffer()->box(0, 0, xsize_ - 1, ysize_ - 1, BACK_COLOR);
	g_shtctl->slide(sht_win_, xpos_, ypos_);
	g_shtctl->updown(sht_win_, 2);
}
DebugWindow::~DebugWindow() {
}

DebugWindow& DebugWindow::operator <<(const char* str)
{
	int x, y, x_max = -1;
	Picture* pict = sht_win_->get_buffer();
	color_16 c;
	if (cursor_y_ > ysize_ - 32) {
		// 炵
		for (y = 3; y < cursor_y_; y++) {
			pict->box(3, y, xsize_ - 4, y, BACK_COLOR);
			for (x = 3; x < xsize_ - 4; x++) {
				c = pict->get_color(x, y + 16);
				if (c == 0xffff) {
					x_max = x_max > x ? x_max : x;
					pict->point(x, y, c);
				}
			}
		}
		pict->putstr(3, cursor_y_ - 16, str, 0xffff);
//		g_shtctl->refresh_map(xpos_, ypos_, xpos_ + xsize_, ypos_ + 19, 2);
//		g_shtctl->refresh(sht_back_, 3, 3, xsize_, 16 + 3);
//		g_shtctl->refresh_map(xpos_, ypos_ + 16 + 3, xpos_ + x_max + 3, ypos_ + ysize_, 2);
//		g_shtctl->refresh(sht_back_, 3, 16 + 3, x_max + 3, ysize_ - 3);
//		g_shtctl->refresh(sht_win_ , 3,      3, x_max + 3, ysize_ - 3);
	} else {
		pict->putstr(3, cursor_y_, str, 0xffff);
		g_shtctl->refresh(sht_win_, 3, cursor_y_ - 16, 8 * strlen(str) + 3, cursor_y_);
		cursor_y_ += 16;
	}
	flush(x_max);
	return *this;
}

void DebugWindow::flush(int xmax) {
	if (xmax < 0) { xmax = xsize_; }
	g_shtctl->refresh_map(xpos_ + 3, ypos_ + 3, xpos_ + xsize_, ypos_ + 19, 0);
	g_shtctl->refresh_sub(xpos_ + 3, ypos_ + 3, xpos_ + xsize_, ypos_ + 19, 0, sht_win_->get_height());
	g_shtctl->refresh_map(xpos_ + 3, ypos_ + 19, xpos_ + 3 + xmax, ypos_ + ysize_, 0);
	//g_shtctl->refresh(sht_win_ , 3, 3, xsize_ - 3, ysize_ - 3);
	g_shtctl->refresh_sub(xpos_ + 3, ypos_ + 19, xpos_ + 3 + xmax, ypos_ + ysize_, 0, sht_win_->get_height());
}
