#ifndef DESCTABLE_H_
#define DESCTABLE_H_

namespace system
{
	//const dword ADR_IDT			= 0x0026f800;
	const dword ADR_IDT			= 0x00000000;
	//const dword LIMIT_IDT		= 0x000007ff;
	const dword LIMIT_IDT		= 0x000003ff;
	const dword ADR_GDT			= 0x00270000;
	const dword LIMIT_GDT		= 0x0000ffff;
	const dword ADR_BOTPAK		= 0x00280000;
	const dword LIMIT_BOTPAK	= 0x0007ffff;
	const dword AR_DATA32_RW	= 0x4092;
	const dword AR_CODE32_ER	= 0x409a;
	const dword AR_LDT			= 0x0082;
	const dword AR_TSS32		= 0x0089;
	const dword AR_INTGATE32	= 0x008e;

	struct SegmentDescriptor
	{
		short limitLow, baseLow;
		char baseMid, accessRight, limitHigh, baseHigh;
	};
	struct GateDescriptor
	{
		short offsetLow, selector;
		char dwCount, accessRight;
		short offsetHigh;
	};
	class GDT
	{
	public:
		static SegmentDescriptor *gdt;
		static void SetSegmDesc(SegmentDescriptor *sd, unsigned int limit, unsigned int base, unsigned int ar);
		static void init();
	};
	class IDT
	{
	public:
		static GateDescriptor *idt;
		static void SetGateDesc(GateDescriptor *gd, unsigned int offset, unsigned int selector, unsigned int ar);
		static void init();
	};
}

#endif /*DESCTABLE_H_*/
