#include "../bootpack.h"

FileEntry::FileEntry()
	: size_(0), data_(NULL)
{
	strcpy(name_, "FILENAMEEXT");
}

FileEntry::FileEntry(const FileEntry& rhs)
	: size_(rhs.size_)
{
	strcpy(name_, rhs.name_);
	data_ = new byte[size_];
	memcpy(data_, rhs.data_, size_);
}

FileEntry::~FileEntry() {
	delete[] data_;
}

FileEntry& FileEntry::operator =(const FileEntry& rhs) {
	size_ = rhs.size_;
	strcpy(name_, rhs.name_);
	if (data_ != NULL) {
		delete[] data_;
	}
	data_ = new byte[size_];
	memcpy(data_, rhs.data_, size_);
}

void FileEntry::init(const char* name, int size) {
	size_ = size;
	strncpy(name_, name, 11);
	name_[11] = '\0';
	if (data_ != NULL) {
		delete[] data_;
	}
	data_ = new byte[size_];
}
