/*
    Copyright (c) 2007 uchan
*/
#ifndef MEMORY_H_
#define MEMORY_H_

namespace system {

	class Memory {
	private:
	    dword start, end, firstFree;
	    dword used;
	
	public:
	    Memory();
	    ~Memory();
	
	  public:
	    void init(dword start, dword end);
	    void* allocate(dword size);
	    void free(void* address);
	    dword getMemorySize(dword start, dword end);
	    dword getMemorySizeSub(dword start, dword end);
	    dword getFreeSize();
	
	private:
	    dword searchFit(dword size);
	    bool checkAddress(dword ptr, dword* prev);
	    void setNext(dword ptr, dword next);
	    dword getNext(dword ptr);
	};
}

using namespace system;
extern Memory g_km;

/*
 * malloc, free, new, deletẽT|[g
 */

extern "C" {
	void* malloc(size_t size);
	void* calloc(size_t size);
	void free(void* p);
}

void* operator new(size_t size);
void* operator new[](size_t size);
void operator delete(void* p);
void operator delete[](void* p);

#endif /*MEMORY_H_*/
