#include "../bootpack.h"

SNode::SNode(const char* name, int size)
: snodes_(size), back_link_(NULL), name_(name), sht_(NULL), fix_sheet_(false),
	xsize_(-1), ysize_(-1), ypos_(0), handler_(NULL), row_height_(32)
{
}

SNode::~SNode()
{
}

void SNode::add(SNode* snode)
{
	snodes_.add(snode);
	snode->back_link_ = this;
}

SNode* SNode::get(int index)
{
	return snodes_.get(index);
}

SNode* SNode::get_backlink()
{
	return back_link_;
}

int SNode::size()
{
	return snodes_.size();
}

void SNode::setname(const char* str)
{
	name_ = str;
}

const char* SNode::getname()
{
	return name_;
}

void SNode::show_nodes(int xpos, int ypos)
/*
 * ̃m[hɓo^Ăm[h\
 * 
 * xpos, ypos : \ʒu
 */
{
	int i;
	int xsize = xsize_, ysize = ysize_;
	ypos_ = ypos;
	if (!fix_sheet_) {
		sht_ = g_shtctl->alloc(TASK_TASKBAR);
		if (xsize_ == -1) {
			xsize = 200;
		}
		if (ysize_ == -1) {
			ysize = 20 + snodes_.size() * row_height_;
		}
		sht_->init(xsize, ysize);
		sht_->set_fix(true);
		Picture* buf = sht_->get_buffer();
		buf->box(0, 0, xsize - 1, ysize - 1, convC(0x556677));
	}
	for (i = 0; i < size(); i++) {
		Picture* buf = sht_->get_buffer();
		buf->putstr(10, 10 + i * row_height_ + (row_height_ - 16) / 2, get(i)->getname(), 0xffff);
	}
	g_shtctl->slide(sht_, xpos, ypos);
	g_shtctl->updown(sht_, 1000);
}

void SNode::show_nodes2(int xpos, int ypos)
{
	if (ysize_ != -1) {
		ypos -= ysize_;
	} else {
		ypos -= size() * row_height_;
	}
	show_nodes(xpos, ypos);
}

void SNode::close_nodes()
{
	ypos_ = 0;
	if (sht_ != NULL) {
		g_shtctl->updown(sht_, -1);
		if (!fix_sheet_) {
			g_shtctl->free(sht_);
			sht_ = NULL;
		} else {
			// \tbV
			int xsize = xsize_, ysize = ysize_;
			if (xsize_ == -1) {
				xsize = 200;
			}
			if (ysize_ == -1) {
				ysize = 20 + snodes_.size() * row_height_;
			}
			Picture* buf = sht_->get_buffer();
			buf->box(0, 0, xsize - 1, ysize - 1, convC(0x556677));
		}
		
		// ʂ̃m[h
		for (int i = 0; i < snodes_.size(); i++) {
			snodes_.get(i)->close_nodes();
		}
	}
}

void SNode::fix_sheet(bool fix)
{
	int xsize = xsize_, ysize = ysize_;
	if (!fix_sheet_ && fix && sht_ == NULL) {
		sht_ = g_shtctl->alloc(TASK_TASKBAR);
		if (xsize_ == -1) {
			xsize = 200;
		} else if (ysize_ == -1) {
			ysize = 20 + snodes_.size() * row_height_;
		}
		sht_->init(xsize, ysize);
		sht_->set_fix(true);
		Picture* buf = sht_->get_buffer();
		buf->box(0, 0, xsize - 1, ysize - 1, convC(0x556677));
	} else if (fix_sheet_ && !fix && sht_ != NULL) {
		if (sht_->get_height() != -1) {
			// ܂\Ȃ̂ŁAĂ͂܂
		} else {
			g_shtctl->free(sht_);
			sht_ = NULL;
		}
	}
	fix_sheet_ = fix;
}

void SNode::set_color(int index, color_16 bgcolor, color_16 color)
{
	if (sht_ != NULL) {
		if (xsize_ == -1) { xsize_ = 200; }
		Picture* buf = sht_->get_buffer();
		buf->box(10, 10 + index * row_height_, xsize_ - 10 - 1, 10 + (index + 1) * row_height_ - 1, bgcolor);
		buf->putstr(10, 10 + index * row_height_ + (row_height_ - 16) / 2, get(index)->getname(), color);
		g_shtctl->refresh(sht_, 10, 10 + index * row_height_, xsize_ - 10, 10 + (index + 1) * row_height_);
	}
}

void SNode::event_click(Task* fromtask)
{
	if (handler_ != NULL) {
		(*handler_)(fromtask);
	}
}

