#include "../../bootpack.h"
using namespace systemtask;

void system::task_power()
{
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	Timer* tim = g_timerctl->alloc();
	tim->set_task(task, 1);
	//timer_settime(tim, 100);
	Picture* buffer_back = g_sheet_back->get_buffer();
	int x, y;
	char s[256];
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::SYSTEM && msg->arg1 == MSG::SYSTEM::REBOOT) {
//			Mouse::out(0xf5); // f[^M֎~
			
			// }EXɃf[^M~߂vo
			IO8 keydat(Keyboard::PORT_KEYDAT);
			IO8 keycmd(Keyboard::PORT_KEYCMD);
			Keyboard::wait_sendready();
			keycmd << Mouse::KEYCMD_SENDTO_MOUSE;
			Keyboard::wait_sendready();
			keydat << 0xf5;
			while (task1_fifo->size() > 0) {
				task1_fifo->pop();
			}
			for (y = 0; y < buffer_back->get_ysize(); y++) {
				for (x = 0; x < buffer_back->get_xsize(); x++) {
					g_screen->point(x, y,
						mixC(
							convC_inv(g_screen->get_color(x, y)), 0xa0a0a0, 50, 50
							)
						);
				}
			}
			*dbg << "rebooting system.";
			dbg->flush();
			cnt_timeout = 0;
			timer_settime(tim, 100);
		} else if (msg->type == MSG::TYPE::TIMER && msg->arg1 == 1) {
			if (cnt_timeout < 2) {
				sprintf(s, "%d", 2 - cnt_timeout);
				cnt_timeout++;
				timer_settime(tim, 100);
				*dbg << s;
				dbg->flush();
			} else {
				io_cli();
				IO8 KBC(0x64);
				KBC << 0xfe; // reboot
				for (;;) { io_hlt(); }
			}
		}
		fifo->pop();
	}
}
