#include "../../bootpack.h"
using namespace systemtask;

namespace startmenu {
	SNode* now_node = NULL;
	int depth = -1; // \j[̊Kw
	int index_old = -1;

	const int sb_xpos1 = 10; // Start Button X POSition
	const int sb_xsize = 8 * 5 + 10;
	const int sb_xpos2 = sb_xpos1 + sb_xsize;
	const int sb_ypos1 = 1;
	const int sb_ysize = 24;
	const int sb_ypos2 = sb_ypos1 + sb_ysize;
	const int margin_top = 10; // j[Xg̏]
	
	const int column_width = 200; // ̕
}
using namespace startmenu;

void click_menubutton(Sheet* taskbar, SNode* root, int xpos_, int ypos_);
void move_mouse(Sheet* taskbar, SNode* root, int xpos_, int ypos_);

void handler_1101(Task* fromtask)
{
/*	Picture* buffer_back = g_sheet_back->get_buffer();
	int x, y;
	Mouse::out(0xf5); // f[^M֎~
	while (task1_fifo->size() > 0) {
		task1_fifo->pop();
	}
	for (y = 0; y < buffer_back->get_ysize(); y++) {
		for (x = 0; x < buffer_back->get_xsize(); x++) {
			g_screen->point(x, y,
				mixC(
					convC_inv(g_screen->get_color(x, y)), 0xa0a0a0, 50, 50
					)
				);
		}
	}
	*dbg << "rebooting system.";
	dbg->flush();
	io_cli();
	IO8 KBC(0x64);
	KBC << 0xfe; // reboot
	for (;;) { io_hlt(); }
*/
//	*dbg << "test";

	Message::send(
		TASK_POWER,
		Message::create(MSG::TYPE::SYSTEM, MSG::SYSTEM::REBOOT)
		);
}

void handler_opencons(Task* fromtask)
{
	Task* task_cons = g_taskctl->alloc(1, 1);
	task_cons->set_tss_esp((dword)malloc(64 * 1024) + 64 * 1024);
	task_cons->set_tss_eip((dword)&system::task_console);
	g_taskctl->run(task_cons);
}

void make_menubutton(Sheet* taskbar, bool active)
{
	Picture* buffer = taskbar->get_buffer();
	if (active) {
		//box_sht(taskbar, 1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0xCCCCCC));
		//putstr_sht(taskbar, 10 + 4, 5, "", 0x0000, convC(0xCCCCCC));
		buffer->box(1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x006400));
		int xsize = 20 + 8 * 5;
		buffer->box(2,  2, xsize - 3,  2, convC(0x567056));
		buffer->box(2,  3, xsize - 3,  3, convC(0x597b5d));
		buffer->box(2,  4, xsize - 3,  4, convC(0x496e4b));
		buffer->box(2,  5, xsize - 3,  5, convC(0x406641));
		buffer->box(2,  6, xsize - 3,  6, convC(0x385f39));
		buffer->box(2,  7, xsize - 3,  7, convC(0x355c37));
		buffer->box(2,  8, xsize - 3,  8, convC(0x305732));
		buffer->box(2,  9, xsize - 3, 10, convC(0x2d532f));
		buffer->box(2, 11, xsize - 3, 15, convC(0x1b3d1c));
		buffer->box(2, 16, xsize - 3, 16, convC(0x193b19));
		buffer->box(2, 17, xsize - 3, 18, convC(0x1c411c));
		buffer->box(2, 19, xsize - 3, 20, convC(0x235123));
		buffer->box(2, 21, xsize - 3, 21, convC(0x265826));
		buffer->box(2, 22, xsize - 3, 23, convC(0x285c28));
		buffer->box(2, 24, xsize - 3, 24, convC(0x688869));
		buffer->putstr(10 + 4, 5, "", 0xffff);
		g_shtctl->refresh(taskbar, 1, 1, 20 + 8 * 5 - 1, buffer->get_ysize() - 1);
	} else {
		//box_sht(taskbar, 1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x203050));
		//putstr_sht(taskbar, 10 + 4, 5, "", 0xffff, convC(0x203050));
		buffer->box(1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x101726));
		int xsize = 20 + 8 * 5;
		buffer->box(2,  2, xsize - 3,  3, convC(0x67737c));
		buffer->box(2,  4, xsize - 3,  5, convC(0x626e78));
		buffer->box(2,  6, xsize - 3,  7, convC(0x5c6974));
		buffer->box(2,  8, xsize - 3,  9, convC(0x5a6773));
		buffer->box(2, 10, xsize - 3, 11, convC(0x556271));
		buffer->box(2, 12, xsize - 3, 13, convC(0x4b5767));
		buffer->box(2, 14, xsize - 3, 15, convC(0x334152));
		buffer->box(2, 16, xsize - 3, 17, convC(0x313e4f));
		buffer->box(2, 18, xsize - 3, 19, convC(0x2d394a));
		buffer->box(2, 20, xsize - 3, 21, convC(0x2a3446));
		buffer->box(2, 22, xsize - 3, 23, convC(0x273142));
		buffer->putstr(10 + 4, 5, "", 0xffff);
		g_shtctl->refresh(taskbar, 1, 1, 20 + 8 * 5 - 1, buffer->get_ysize() - 1);
	}
}

void click_menubutton(Sheet* taskbar, SNode* root, int xpos_, int ypos_)
{
	static bool open = false; // j[JĂ邩ǂ
	bool exec_close = false; // Ƃ邩ǂ
	int xpos = xpos_; // ^XNo[̍
	int ypos = taskbar->get_ypos() - ypos_; // ^XNo[̏(ɍsق+)
	//static int depth = -1; // \j[̊Kw
	//static SNode* now_node = NULL;
	int i, j;
	int clicked_num = 0; // ォ牽Ԗڂ̗vfNbNꂽ
	Task* task = g_taskctl->get_current_task();
	
	const int tb_ypos = taskbar->get_ypos();
	
	//*dbg << "debug:1000";
	
	
	if (sb_xpos1 <= xpos && xpos < sb_xpos2 && sb_ypos1 <= -ypos && -ypos < sb_ypos2) {
		// X^[g{^NbN
		if (!open) {
			//*dbg << "debug:2000";
			open = true;
			depth++;
			now_node = root;
			if (root->get_ysize() != -1) {
				root->show_nodes(depth * 200, tb_ypos - root->get_ysize());
			}
			make_menubutton(taskbar, true);
		} else {
			//*dbg << "debug:2500";
			exec_close = true;
		}
	}
	if (ypos >= 0) {
		// ^XNo[NbNꍇ
		if (open) {
			/*
			 * j[JĂƂȏꍇɎsB
			 * ԊKw̐[ƂNbNĂƂ͌Ȃ̂
			 * NbNKwׂāA܂ŕ\߂B
			 */
			int depth_ = xpos / column_width;
			if (depth_ < depth) {
				j = depth - depth_;
				int ypos0 = now_node->get_ypos();
				int row_height0 = now_node->get_row_height();
				for (; j > 0; j--) {
					now_node = now_node->get_backlink();
				}
				ypos0 -= now_node->get_ypos();
				ypos0 /= row_height0;
				now_node->set_color(ypos0, convC(0x556677), convC(0xffffff));
				for (i = 0; i < now_node->size(); i++) {
					now_node->get(i)->close_nodes();
				}
				depth = depth_;
				move_mouse(taskbar, root, xpos_, ypos_);
			}
		}
		if (depth * column_width <= xpos && xpos < (depth + 1) * column_width) {
			clicked_num = ypos_ - now_node->get_ypos();
			clicked_num -= margin_top;
			int temp = clicked_num;
			clicked_num /= now_node->get_row_height();
			if (0 <= clicked_num && clicked_num < now_node->size()) {
				if (now_node->get(clicked_num)->size() != 0) {
					// vfł͂Ȃ
					// ܂ATuj[\
					depth++;
					now_node = now_node->get(clicked_num);
					now_node->show_nodes(
						depth * column_width,
						ypos_ - (temp % now_node->get_row_height()) - margin_top
						);
				} else {
					// vfł
					// ܂AR}hs
					now_node->set_color(clicked_num, convC(0x556677), convC(0xffffff));
					now_node = now_node->get(clicked_num);
					now_node->event_click(task);
					exec_close = true;
				}
			}
		}
	}
	if (exec_close) {
		//*dbg << "debug:3000";
		open = false;
		depth = -1;
		now_node = NULL;
		//*dbg << "debug:3200";
		root->close_nodes();
		//*dbg << "debug:3300";
		exec_close = false;
		//*dbg << "debug:3400";
		make_menubutton(taskbar, false);
		//*dbg << "debug:3500";
		index_old = -1;
		//*dbg << "debug:4000";
	}
}

void move_mouse(Sheet* taskbar, SNode* root, int xpos_, int ypos_)
{
	//int depth = 0;
	int i;
	//SNode* now_node = root;
	//static SNode* past_node = NULL;
	int index = 0;
	//static int index_old = -1;
	
	if (now_node == NULL) {
		return;
	}
	int depth_ = xpos_ / column_width;
//	index = ypos_ - now_node->get_ypos();
//	index -= margin_top;
//	index /= now_node->get_row_height();
	//if (index == index_old/* && now_node == past_node*/ && depth == depth_) {
	//	return;
	//}

	SNode* temp = now_node;
	for (i = depth; i > depth_; i--) {
		temp = temp->get_backlink();
	}
	index = ypos_ - temp->get_ypos();
	index -= margin_top;
	index /= temp->get_row_height();

#if 1
	if (0 <= index && index < now_node->size()) {
		if (index_old != -1 && index_old != index/* && now_node == past_node*/) {
		//if (index_old != index && index_old >= 0) {
			now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
		}
		
		if (depth == depth_) {
			now_node->set_color(index, convC(0x0000ff), convC(0x00ff00));
//			past_node = now_node;
			index_old = index;
		} else if (depth_ < depth/* && index_old != index*/ && index_old != -1) {
//			SNode* temp = now_node;
//			for (i = depth; i > depth_; i--) {
//				temp = temp->get_backlink();
//			}
			now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
			//temp->set_color(index, convC(0x0000ff), convC(0x00ff00));
			index_old = index;
		}
	} else if (index_old >= 0 && index_old < now_node->size()) {
		now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
		index_old = index;
	}
#endif
}


void system::task_taskbar() {
	Picture* buffer_back = g_sheet_back->get_buffer();
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	int i;
	int depth = -1; // ݕ\̃j[̐[
	
	int mode = 0; // j[\[h 0: 1:
	
	const int row_height = 32; // j[P̍
	
	DateTime date1, date2;
	char s[256];

	Sheet* taskbar = get_sheet_taskid(g_taskctl->get_taskid(task));
	Picture* buffer = taskbar->get_buffer();
	
	const int height0 = taskbar->get_ypos() - 400; // \郁j[̍
	int height = height0;
	
	//box_sht(taskbar, 1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x203050));
	//putstr_sht(taskbar, 10 + 4, 5, "", 0xffff, convC(0x203050));
	make_menubutton(taskbar, false);
	
	Timer* tim1 = g_timerctl->alloc();
	tim1->set_task(task, 1);
	timer_settime(tim1, 5);
	Timer* tim2 = g_timerctl->alloc();
	tim2->set_task(task, 2);
	timer_settime(tim2, 3);
	
	bool menu_open = false;
	Sheet* m1 = NULL;
	Picture* b1 = NULL;
	Sheet* m2 = NULL;
	Picture* b2 = NULL;
	
	
	// ɃX^[gj[ɓeo^
	SNode* root = new SNode("start");
	root->set_xsize(200);
	root->set_ysize(400);
	root->fix_sheet();
	m1 = root->get_sheet();
	b1 = m1->get_buffer();
/*	SNode* snodes[32];
	snodes[0] = new SNode("programs");
	snodes[1] = new SNode("My Computer");
	snodes[2] = new SNode("My Document");
	snodes[3] = new SNode("1001");
	snodes[4] = new SNode("1002");
	snodes[5] = new SNode("2001");
	snodes[6] = new SNode("2002");
	snodes[7] = new SNode("3001");
	snodes[8] = new SNode("3002");
	snodes[9]  = new SNode("1101");
	snodes[10] = new SNode("1102");
	snodes[11] = new SNode("1201");
	snodes[12] = new SNode("1202");
	snodes[13] = new SNode("2101");
	snodes[14] = new SNode("2102");
	snodes[15] = new SNode("2201");
	snodes[16] = new SNode("2202");
	snodes[17] = new SNode("3101");
	snodes[18] = new SNode("3102");
	snodes[19] = new SNode("3201");
	snodes[20] = new SNode("3202");
*/

	SNode* snodes = new SNode[32];
	snodes[0].setname("Power");
	snodes[1].setname("Reboot");
	snodes[0].add(&snodes[1]);
	
	snodes[2].setname("Accessory");
	snodes[3].setname("Command Prompt");
	snodes[2].add(&snodes[3]);
	
	snodes[4].setname("My Computer");
	
	snodes[5].setname("My Document");
	
	snodes[6].setname("test menu");
	snodes[6].add(&snodes[7]);
	snodes[7].setname("001");
	snodes[7].add(&snodes[8]);
	snodes[8].setname("001");
	snodes[8].add(&snodes[9]);
	snodes[9].setname("001");
	
	root->add(&snodes[0]);
	root->add(&snodes[2]);
	root->add(&snodes[4]);
	root->add(&snodes[5]);
	root->add(&snodes[6]);
	
	//SNode* now_node = NULL; // ݊JĂm[h
	
	snodes[1].set_handler(&handler_1101);
	snodes[3].set_handler(&handler_opencons);
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::TIMER) {
			if (msg->arg1 == 1) {
				timer_settime(tim1, 100);
				buffer->box(buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 3, 17, Screen::TASKBAR_COLOR);
				sprintf(s, "%02d/%02d  %02d:%02d",
					date1.month, date1.day, date1.hour, date1.minute, date1.second);
				buffer->putstr(buffer->get_xsize() - 6 * 12 - 2, 6, s, 0x0000, font_mini);
				g_shtctl->refresh(taskbar, buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 2, 18);
				date1.second++;
				if (date1.second >= 60) {
					date1.second = 0;
					date1.minute++;
				}
				if (date1.minute >= 60) {
					date1.minute = 0;
					date1.hour++;
				}
				if (date1.hour >= 24) {
					date1.hour = 0;
					date1.day++;
				}
				if ((date1.day > 31 &&
					(date1.month == 1 || date1.month == 3 || date1.month == 5 ||
					date1.month == 7 || date1.month == 8 || date1.month == 10 ||
					date1.month == 12)) ||
					(date1.day > 30 &&
					(date1.month == 4 || date1.month == 6 || date1.month == 9 ||
					date1.month == 11)) ||
					(date1.day > 28 && date1.month == 2))
				{
					date1.day = 0;
					date1.month++;
				}
				if (date1.month > 12) {
					date1.month = 0;
					date1.year++;
				}
			} else if (msg->arg1 == 2) {
				timer_settime(tim2, 6000);
				RTC::read(&date1);
				RTC::read(&date2);
				int i = 0;
				while (date1 != date2 ||
					(date1.second < 0 || date1.second > 60) ||
					(date1.minute < 0 || date1.minute > 59) ||
					(date1.hour < 0 || date1.hour > 24) ||
					(date1.day < 1 || date1.day > 31) ||
					(date1.month < 1 || date1.month > 12) ||
					(date1.year < 1990))
				{
					RTC::read(&date1);
					RTC::read(&date2);
					if (i > 5) { break; }
					i++;
				}
			}
		} else if (msg->type == MSG::TYPE::MOUSE && msg->arg1 == MSG::MOUSE::COORDINATE) {
			sprintf(s, "clicked %04d, %03d", msg->arg2, msg->arg3);
			buffer->box(200, 7, 200 + 8 * 17 - 1, 22, Screen::TASKBAR_COLOR);
			buffer->putstr(200, 7, s, 0x0000);
			g_shtctl->refresh(taskbar, 200, 7, 200 + 8 * 17, 23);
//			if (10 <= msg->arg2 && msg->arg2 < 20 + 8 * 5 &&
//				taskbar->get_ypos() + 1 <= msg->arg3 && msg->arg3 < taskbar->get_ypos() + 26) {
//				click_menubutton(taskbar, root, msg->arg2, msg->arg3);
//			}
			if (msg->arg4 == MSG::MOUSE::RIGHT_PUSH) {
				click_menubutton(taskbar, root, msg->arg2, msg->arg3);
			} else if (msg->arg4 == 0) {
				move_mouse(taskbar, root, msg->arg2, msg->arg3);
			}
#if 0
			int xpos = msg->arg2;
			int ypos0 = msg->arg3;
			int ypos = msg->arg3 - (taskbar->get_ypos() - 400);
			if (menu_open) {
				int depth_temp = xpos / 200;
				int j = depth - depth_temp;
				for (i = 0; i < j; i++) {
					now_node = now_node->get_backlink();
				}
				if (j != 0) {
					for (i = 0; i < now_node->size(); i++) {
						now_node->get(i)->close_nodes();
					}
				}
				depth = depth_temp;
			}
			int temp = now_node->get_ypos() - (taskbar->get_ypos() - 400);
			if (temp < 0) { temp = -temp; }
			//temp = (temp + 0x0f) & 0xfff0;
			temp = temp & 0xfff0;
			if (10 <= xpos && xpos < 20 + 8 * 5 && !menu_open) {
				make_menubutton(taskbar, true);
				now_node = root;
				menu_open = true;
				depth++;
				if (mode == 0) {
					root->show_nodes(0, taskbar->get_ypos() - 400);
				} else if (mode == 1) {
					root->show_nodes2(0, taskbar->get_ypos());
				}
				//root->show_nodes(0, taskbar->get_ypos() - 400);
				//root->show_nodes2(0, taskbar->get_ypos());
				//root->show_nodes(0, height);
			} else if (10 + 200 * depth <= xpos && xpos <= 190 + 200 * depth && ypos <= 10 + temp + now_node->size() * row_height && menu_open) {
				// X^[gj[̒̍ڂNbNꂽ
//				if (m2 != NULL) {
//					g_shtctl->updown(m2, -1);
//					g_shtctl->free(m2);
//					m2 = NULL;
//				}
//				if (now_node != root && now_node != NULL) {
//					now_node->close_nodes();
//					now_node = root;
//				}
//				now_node = root;
//				for (i = 0; i < depth; i++) {
//					now_node = now_node->get(i);
//				}

				for (i = 0; i < now_node->size(); i++) {
					if (10 + temp + row_height * i <= ypos && ypos < 10 + temp + row_height * i + row_height) {
						b1->box(10, 26 + row_height * 10, 190 - 1, 26 + row_height * 11 - 1, convC(0x556677));
						b1->putstr(10, 26 + row_height * 10, now_node->get(i)->getname(), 0xffff);
						g_shtctl->refresh(m1, 10, 26 + row_height * 10, 190, 26 + row_height * 11);

//						m2 = g_shtctl->alloc(TASK_TASKBAR);
//						m2->init(200, 20 + root->get(i)->size() * 16);
//						m2->set_fix(true);
//						b2 = m2->get_buffer();
//						b2->box(0, 0, 200 - 1, 20 + root->get(i)->size() * 16 - 1, convC(0x556677));
//						g_shtctl->slide(m2, 200, taskbar->get_ypos() - 400 + i * 16);
//						g_shtctl->updown(m2, 1000);
						if (now_node->get(i)->size() != 0) {
							depth++;
							now_node = now_node->get(i);
							height += i * row_height;
							//now_node->show_nodes(200 * depth, taskbar->get_ypos() - 400 /*+ 26 + i * 16*/);
							//now_node->show_nodes(200 * depth, ypos0);
							if (mode == 0) {
								now_node->show_nodes(200 * depth, now_node->get_backlink()->get_ypos() + i * row_height);
							} else if (mode == 1) {
								now_node->show_nodes2(200 * depth, (ypos0 - 10) & 0xfff0);
							}
						} else {
							// [̍ڂł
							now_node->get(i)->event_click(task);
							root->close_nodes();
							now_node = NULL;
							menu_open = false;
							depth = -1;
							height = height0;
							make_menubutton(taskbar, false);
						}
						//root->get(i)->show_nodes(200, 400);
						break;
					}
				}
			} else if (10 <= xpos && xpos < 20 + 8 * 5 && 
						taskbar->get_ypos() <= ypos0 && ypos0 < taskbar->get_ypos() + 26 &&
						menu_open) {
				root->close_nodes();
				//g_shtctl->updown(m1, -1);
//				g_shtctl->updown(m2, -1);
//				g_shtctl->free(m2);
				//now_node->close_nodes();
				make_menubutton(taskbar, false);
				now_node = NULL;
				//m2 = NULL;
				menu_open = false;
				depth = -1;
				height = height0;
			}
#endif

		}
		fifo->pop();
	}
}
