// $Id: alpha_beta.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_ALPHA_BETA_H
#define NSIM_ALPHA_BETA_H

namespace nsim
{

template <typename A, typename B>
struct alpha_beta
{
    A alpha;
    B beta;
    double phi;

    alpha_beta(A const& alpha = A(), B const& beta = B(), double phi = 1.0) :
        alpha(alpha), beta(beta), phi(phi) {}

    double dt(double x, double y) const
    {
        return phi*(alpha(x)*(1.0 - y) - beta(x)*y);
    }
    double tau(double x) const
    {
        return 1/(phi*(alpha(x)+beta(x)));
    }
    double inf(double x) const
    {
        return alpha(x)/(alpha(x)+beta(x));
    }
    double inf_dx(double x) const
    {
        double a(alpha(x));
        double b(beta(x));
        double p(a + b);
        return (alpha.dx(x)*b - a*beta.dx(x))/(p*p);
    }
    double dx(double x, double y) const
    {
        return phi*(alpha.dx(x)*(1.0 - y) - beta.dx(x)*y);
    }
    double dy(double x, double y) const
    {
        return -phi*(alpha(x) + beta(x));
    }
};

}

#endif

