// $Id: pow.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_POW_H
#define NSIM_POW_H

#include <cmath>

namespace nsim
{

template <int P>
struct pow_
{
    template <typename T>
        static T apply(T const& x) { return std::pow(x, P); }
};

template <>
struct pow_<4>
{
    template <typename T>
        static T apply(T const& x) { T xx(x*x); return xx*xx; }
};

template <>
struct pow_<3>
{
    template <typename T>
        static T apply(T const& x) { return x*x*x; }
};

template <>
struct pow_<2>
{
    template <typename T>
        static T apply(T const& x) { return x*x; }
};

template <>
struct pow_<1>
{
    template <typename T>
        static T apply(T const& x) { return x; }
};

template <>
struct pow_<0>
{
    template <typename T>
        static T apply(T const& x) { return T(1); }
};

template <int P, typename T>
    inline T pow(T const& x) { return pow_<P>::apply(x); }

}

#endif
