#ifndef NSIM_TEST_HANDLE_H
#define NSIM_TEST_HANDLE_H

#include <nsim/orbit.h>

namespace test
{

template <typename V>
class handle : public nsim::orbit<V>
{
public:
    typedef V vector_type;

    handle(vector_type const& x) :
        h_(nsim::AUTOSTEP), t_(0.0), x_(x) {}

    double time() const { return t_; }
    vector_type const& state() const { return x_; }

    template <typename model_type>
        void start(model_type const& eq, double& t, vector_type& x, double& h)
        {
            h = h_;
            t = t_;
            x.swap(x_);
        }

    template <typename model_type>
        bool is_active(model_type const& eq,
                double t, vector_type const& x) const
        {
            return t < t_ + 1000.0;
        }

    template <typename model_type, typename Result>
        void accepted(model_type const& eq, Result const& result)
        {
            insert(result);
        }

    template <typename model_type>
        bool modify(model_type const& eq,
                double& t, vector_type& x, double& h) const
        {
            return false;
        }

    template <typename model_type>
        void finish(model_type const& eq, double t, vector_type& x, double h)
        {
            h_ = h;
            t_ = t;
            x_.swap(x);
        }

private:
    double h_;
    double t_;
    vector_type x_;
};

}

#endif
