/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_MUTEX_H_
#define _NT_MUTEX_H_

typedef struct tag_nt_mutex_handle{
	int chk_sum;
} nt_mutex_handle_t, *nt_mutex_handle;


extern void nt_mutex_lib_init();
extern void nt_mutex_lib_finish();

extern BOOL nt_mutex_lock(nt_mutex_handle handle);
extern BOOL nt_mutex_unlock(nt_mutex_handle handle);
extern nt_mutex_handle nt_mutex_get_one_time_handle(const wchar_t *moniker);
extern BOOL nt_mutex_add_moniker(nt_mutex_handle handle, const wchar_t *moniker);

#endif /* _NT_MUTEX_H_ */

